/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.Retained;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;

public class BaseRetained
implements Retained {
    private static final int MAX_TRACES = Integer.getInteger("org.fusesource.hawtdispatch.BaseRetained.MAX_TRACES", 100);
    private static final boolean TRACE = Boolean.getBoolean("org.fusesource.hawtdispatch.BaseRetained.TRACE");
    private final AtomicInteger retained = new AtomicInteger(1);
    private volatile Task disposer;
    private final ArrayList<String> traces = TRACE ? new ArrayList(MAX_TRACES + 1) : null;
    static HashSet<String> CALLERS = new HashSet();

    public final void setDisposer(Runnable disposer) {
        this.setDisposer(new TaskWrapper(disposer));
    }

    public final void setDisposer(Task disposer) {
        this.assertRetained();
        this.disposer = disposer;
    }

    public final Task getDisposer() {
        return this.disposer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void retain() {
        if (TRACE) {
            ArrayList<String> arrayList = this.traces;
            synchronized (arrayList) {
                this.assertRetained();
                int x = this.retained.incrementAndGet();
                this.trace("retained", x);
            }
        } else {
            this.assertRetained();
            this.retained.getAndIncrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        if (TRACE) {
            ArrayList<String> arrayList = this.traces;
            synchronized (arrayList) {
                this.assertRetained();
                int x = this.retained.decrementAndGet();
                this.trace("released", x);
                if (x == 0) {
                    this.dispose();
                    this.trace("disposed", x);
                }
            }
        } else {
            this.assertRetained();
            if (this.retained.decrementAndGet() == 0) {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void release(int n) {
        if (TRACE) {
            ArrayList<String> arrayList = this.traces;
            synchronized (arrayList) {
                this.assertRetained();
                int x = this.retained.addAndGet(-n);
                this.trace("released " + n, x);
                if (x == 0) {
                    this.trace("disposed", x);
                    this.dispose();
                }
            }
        } else {
            this.assertRetained();
            if (this.retained.addAndGet(-n) == 0) {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertRetained() {
        if (TRACE) {
            ArrayList<String> arrayList = this.traces;
            synchronized (arrayList) {
                if (this.retained.get() <= 0) {
                    throw new AssertionError((Object)String.format("%s: Use of object not allowed after it has been released. %s", this.toString(), this.traces));
                }
            }
        } else assert (this.retained.get() > 0) : String.format("%s: Use of object not allowed after it has been released.", this.toString());
    }

    public final int retained() {
        return this.retained.get();
    }

    protected void dispose() {
        Task disposer = this.disposer;
        if (disposer != null) {
            disposer.run();
        }
    }

    private final void trace(final String action, final int counter) {
        if (this.traces.size() < MAX_TRACES) {
            Exception ex = new Exception(){

                public String toString() {
                    return "Trace " + (BaseRetained.this.traces.size() + 1) + ": " + action + ", counter: " + counter + ", thread: " + Thread.currentThread().getName();
                }
            };
            String squashed = BaseRetained.squash(ex.getStackTrace());
            if (squashed == null) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.traces.add("\n" + sw);
            }
        } else if (this.traces.size() == MAX_TRACES) {
            this.traces.add("MAX_TRACES reached... no more traces will be recorded.");
        }
    }

    private static String squash(StackTraceElement[] st) {
        String traceData;
        if (st.length > 2 && CALLERS.contains(traceData = st[2].getClassName() + "." + st[2].getMethodName())) {
            return traceData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (TRACE) {
            Properties p = new Properties();
            InputStream is = BaseRetained.class.getResourceAsStream("BaseRetained.CALLERS");
            try {
                p.load(is);
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
            for (Object key : Collections.list(p.keys())) {
                CALLERS.add((String)key);
            }
        }
    }
}

