/*
 * Decompiled with CFR 0.152.
 */
package org.josql.contrib;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.ExtendFileSelector;
import org.josql.Query;

public class JoSQLAntFileSelector
extends Query
implements ExtendFileSelector {
    private static String sqlPrefix = "SELECT * FROM java.io.File WHERE ";
    public static final String WHERE = "where";
    public static final String DEBUG = "debug";
    private Exception parseExp = null;
    private boolean configured = false;
    private String where = null;
    private boolean debug = false;
    private boolean shownWhere = false;

    public void setParameters(Parameter[] parms) {
        if (parms != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < parms.length; ++i) {
                Parameter p = parms[i];
                if (p.getName().toLowerCase().equals(DEBUG) && p.getValue().toLowerCase().equals("on")) {
                    this.debug = true;
                }
                if (!p.getName().toLowerCase().equals(WHERE)) continue;
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(p.getValue().trim());
            }
            if (buf.length() > 0) {
                try {
                    this.where = buf.toString();
                    this.parse(sqlPrefix + buf.toString());
                    this.configured = true;
                }
                catch (Exception e) {
                    this.parseExp = e;
                }
            }
        }
    }

    public boolean isSelected(File basedir, String filename, File file) throws BuildException {
        if (!this.configured) {
            if (this.parseExp != null) {
                throw new BuildException("Unable to init query with where clause: " + this.where + ", reason: " + this.parseExp.getMessage(), (Throwable)this.parseExp);
            }
            throw new BuildException("Selector is not configured, expected to find a parameter with name: where that provides the where clause to evaluate against each file.");
        }
        if (this.debug && !this.shownWhere) {
            System.out.println("Using WHERE clause: " + this.where);
            this.shownWhere = true;
        }
        try {
            boolean v = this.getWhereClause().isTrue(file, this);
            if (this.debug) {
                System.out.println("WHERE = " + v + " for file: " + file);
            }
            return v;
        }
        catch (Exception e) {
            throw new BuildException("Unable to execute where clause: " + this.getWhereClause() + " on file: " + file + ", reason: " + e.getMessage(), (Throwable)e);
        }
    }
}

