/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimerHeap<V> {
    private final TreeMap<Long, LinkedList<V>> timers = new TreeMap();
    private final TimeUnit resolution = TimeUnit.NANOSECONDS;
    private int size = 0;

    public final void addAbsolute(V timed, long time, TimeUnit timeUnit) {
        this.addInternal(timed, System.nanoTime() + this.resolution.convert(this.resolution.convert(time, timeUnit), timeUnit));
    }

    public final void addRelative(V timed, long delay, TimeUnit timeUnit) {
        this.addInternal(timed, System.nanoTime() + this.resolution.convert(delay, timeUnit));
    }

    private void addInternal(V timed, long eTime) {
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(timed);
        LinkedList old = this.timers.put(eTime, list);
        if (old != null) {
            list.addAll(old);
        }
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public final long timeToNext(TimeUnit unit) {
        if (this.timers.isEmpty()) {
            return -1L;
        }
        return unit.convert(Math.max(0L, this.timers.firstKey() - System.nanoTime()), this.resolution);
    }

    public final void executeReadyTimers() {
        LinkedList ready = null;
        if (this.timers.isEmpty()) {
            return;
        }
        long now = System.nanoTime();
        long first = this.timers.firstKey();
        if (first > now) {
            return;
        }
        ready = new LinkedList();
        while (first <= now) {
            ready.addAll(this.timers.remove(first));
            if (this.timers.isEmpty()) break;
            first = this.timers.firstKey();
        }
        for (Object timed : ready) {
            try {
                this.execute(timed);
                --this.size;
            }
            catch (Throwable thrown) {
                thrown.printStackTrace();
            }
        }
    }

    protected abstract void execute(V var1);
}

