/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.store.leveldb;

import java.io.File;
import java.io.IOException;
import org.apache.activemq.apollo.util.FileSupport$;
import org.apache.activemq.apollo.util.IOHelper;
import org.apache.activemq.apollo.util.Log;
import org.apache.activemq.apollo.util.ProcessSupport$;
import org.fusesource.leveldbjni.internal.Util;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LevelDBClient$
implements Log,
ScalaObject {
    public static final LevelDBClient$ MODULE$;
    private final String STORE_SCHEMA_PREFIX;
    private final int STORE_SCHEMA_VERSION;
    private final byte queue_prefix;
    private final byte queue_entry_prefix;
    private final byte map_prefix;
    private final byte tmp_prefix;
    private final byte[] queue_prefix_array;
    private final byte[] map_prefix_array;
    private final byte[] queue_entry_prefix_array;
    private final byte[] dirty_index_key;
    private final byte[] log_refs_index_key;
    private final byte[] TRUE;
    private final byte[] FALSE;
    private final byte LOG_ADD_QUEUE;
    private final byte LOG_REMOVE_QUEUE;
    private final byte LOG_ADD_MESSAGE;
    private final byte LOG_ADD_QUEUE_ENTRY;
    private final byte LOG_REMOVE_QUEUE_ENTRY;
    private final byte LOG_MAP_ENTRY;
    private final String LOG_SUFFIX;
    private final String INDEX_SUFFIX;
    private final boolean on_windows;
    private int link_strategy;
    private final boolean $enable_assertions;
    private final Logger log;

    static {
        new LevelDBClient$();
    }

    public Logger log() {
        return this.log;
    }

    public void org$apache$activemq$apollo$util$Log$_setter_$log_$eq(Logger logger) {
        this.log = logger;
    }

    public void error(Function0<String> m, Seq<Object> args) {
        Log.class.error((Log)this, m, args);
    }

    public void error(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.error((Log)this, (Throwable)e, m, args);
    }

    public void error(Throwable e) {
        Log.class.error((Log)this, (Throwable)e);
    }

    public void warn(Function0<String> m, Seq<Object> args) {
        Log.class.warn((Log)this, m, args);
    }

    public void warn(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.warn((Log)this, (Throwable)e, m, args);
    }

    public void warn(Throwable e) {
        Log.class.warn((Log)this, (Throwable)e);
    }

    public void info(Function0<String> m, Seq<Object> args) {
        Log.class.info((Log)this, m, args);
    }

    public void info(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.info((Log)this, (Throwable)e, m, args);
    }

    public void info(Throwable e) {
        Log.class.info((Log)this, (Throwable)e);
    }

    public void debug(Function0<String> m, Seq<Object> args) {
        Log.class.debug((Log)this, m, args);
    }

    public void debug(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.debug((Log)this, (Throwable)e, m, args);
    }

    public void debug(Throwable e) {
        Log.class.debug((Log)this, (Throwable)e);
    }

    public void trace(Function0<String> m, Seq<Object> args) {
        Log.class.trace((Log)this, m, args);
    }

    public void trace(Throwable e, Function0<String> m, Seq<Object> args) {
        Log.class.trace((Log)this, (Throwable)e, m, args);
    }

    public void trace(Throwable e) {
        Log.class.trace((Log)this, (Throwable)e);
    }

    public final String STORE_SCHEMA_PREFIX() {
        return "leveldb_store:";
    }

    public final int STORE_SCHEMA_VERSION() {
        return 3;
    }

    public final byte queue_prefix() {
        return this.queue_prefix;
    }

    public final byte queue_entry_prefix() {
        return this.queue_entry_prefix;
    }

    public final byte map_prefix() {
        return this.map_prefix;
    }

    public final byte tmp_prefix() {
        return this.tmp_prefix;
    }

    public final byte[] queue_prefix_array() {
        return this.queue_prefix_array;
    }

    public final byte[] map_prefix_array() {
        return this.map_prefix_array;
    }

    public final byte[] queue_entry_prefix_array() {
        return this.queue_entry_prefix_array;
    }

    public final byte[] dirty_index_key() {
        return this.dirty_index_key;
    }

    public final byte[] log_refs_index_key() {
        return this.log_refs_index_key;
    }

    public final byte[] TRUE() {
        return this.TRUE;
    }

    public final byte[] FALSE() {
        return this.FALSE;
    }

    public final byte LOG_ADD_QUEUE() {
        return this.LOG_ADD_QUEUE;
    }

    public final byte LOG_REMOVE_QUEUE() {
        return this.LOG_REMOVE_QUEUE;
    }

    public final byte LOG_ADD_MESSAGE() {
        return this.LOG_ADD_MESSAGE;
    }

    public final byte LOG_ADD_QUEUE_ENTRY() {
        return this.LOG_ADD_QUEUE_ENTRY;
    }

    public final byte LOG_REMOVE_QUEUE_ENTRY() {
        return this.LOG_REMOVE_QUEUE_ENTRY;
    }

    public final byte LOG_MAP_ENTRY() {
        return this.LOG_MAP_ENTRY;
    }

    public final String LOG_SUFFIX() {
        return ".log";
    }

    public final String INDEX_SUFFIX() {
        return ".index";
    }

    public byte[] bytes(String value) {
        return value.getBytes("UTF-8");
    }

    public File create_sequence_file(File directory, long id, String suffix) {
        return FileSupport$.MODULE$.to_rich_file(directory).$div(Predef$.MODULE$.augmentString("%016x%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id), suffix})));
    }

    public TreeMap<Object, File> find_sequence_files(File directory, String suffix$1) {
        return (TreeMap)TreeMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])FileSupport$.MODULE$.to_rich_file(directory).list_files()).flatMap((Function1)new Serializable(suffix$1){
            public static final long serialVersionUID;
            private final String suffix$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Iterable<Tuple2<Object, File>> apply(File f) {
                void var2_2;
                Iterable iterable;
                if (!f.getName().endsWith(this.suffix$1)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    return iterable;
                }
                Iterable exceptionResult5 = null;
                try {
                    String base = Predef$.MODULE$.augmentString(f.getName()).stripSuffix(this.suffix$1);
                    long position = Long.parseLong(base, 16);
                    exceptionResult5 = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)position)).$minus$greater((Object)f)));
                }
                catch (NumberFormatException numberFormatException) {
                    exceptionResult5 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                iterable = var2_2;
                return iterable;
            }
            {
                this.suffix$1 = string;
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)Manifest$.MODULE$.Long(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{ClassManifest$.MODULE$.classType(File.class)}))))), (Ordering)Ordering$Long$.MODULE$);
    }

    public boolean on_windows() {
        return this.on_windows;
    }

    public int link_strategy() {
        return this.link_strategy;
    }

    public void link_strategy_$eq(int n) {
        this.link_strategy = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void link(File source, File target) {
        int n = this.link_strategy();
        switch (n) {
            default: {
                FileSupport$.MODULE$.to_rich_file(source).copy_to(target);
                return;
            }
            case 0: {
                try {
                    Util.link((File)source, (File)target);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug((Function0)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Native link system call not available";
                        }
                    }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    this.link_strategy_$eq(2);
                    this.link(source, target);
                    return;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            case 2: {
                try {
                    IOHelper.hardlink((File)source, (File)target);
                    return;
                }
                catch (Throwable throwable) {
                    this.debug((Function0)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "JNA based hard link system call not available";
                        }
                    }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    this.link_strategy_$eq(5);
                    this.link(source, target);
                    return;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
            }
            case 5: {
                try {
                    if (this.on_windows()) {
                        Tuple3 tuple3 = ProcessSupport$.MODULE$.system((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fsutil", "hardlink", "create", target.getCanonicalPath(), source.getCanonicalPath()}));
                        if (tuple3 == null) throw new MatchError((Object)tuple3);
                        if (BoxesRunTime.unboxToInt((Object)tuple3._1()) == 0) return;
                        this.debug((Function0)new Serializable(){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return "fsutil OS command not available either";
                            }
                        }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                        this.link_strategy_$eq(10);
                        this.link(source, target);
                        return;
                    }
                    Tuple3 tuple3 = ProcessSupport$.MODULE$.system((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ln", source.getCanonicalPath(), target.getCanonicalPath()}));
                    if (tuple3 == null) throw new MatchError((Object)tuple3);
                    if (BoxesRunTime.unboxToInt((Object)tuple3._1()) == 0) return;
                    this.debug((Function0)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "ln OS command not available either";
                        }
                    }, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    this.link_strategy_$eq(10);
                    this.link(source, target);
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }
    }

    public final boolean $enable_assertions() {
        return this.$enable_assertions;
    }

    private LevelDBClient$() {
        MODULE$ = this;
        Log.class.$init$((Log)this);
        this.queue_prefix = (byte)113;
        this.queue_entry_prefix = (byte)101;
        this.map_prefix = (byte)112;
        this.tmp_prefix = (byte)116;
        this.queue_prefix_array = Array$.MODULE$.apply(this.queue_prefix(), (Seq)Predef$.MODULE$.wrapByteArray(new byte[0]));
        this.map_prefix_array = Array$.MODULE$.apply(this.map_prefix(), (Seq)Predef$.MODULE$.wrapByteArray(new byte[0]));
        this.queue_entry_prefix_array = Array$.MODULE$.apply(this.queue_entry_prefix(), (Seq)Predef$.MODULE$.wrapByteArray(new byte[0]));
        this.dirty_index_key = this.bytes(":dirty");
        this.log_refs_index_key = this.bytes(":log-refs");
        this.TRUE = this.bytes("true");
        this.FALSE = this.bytes("false");
        this.LOG_ADD_QUEUE = (byte)1;
        this.LOG_REMOVE_QUEUE = (byte)2;
        this.LOG_ADD_MESSAGE = (byte)3;
        this.LOG_ADD_QUEUE_ENTRY = (byte)5;
        this.LOG_REMOVE_QUEUE_ENTRY = (byte)6;
        this.LOG_MAP_ENTRY = (byte)7;
        this.on_windows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        this.link_strategy = 0;
        this.$enable_assertions = this.getClass().desiredAssertionStatus();
    }
}

