/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import com.gokgs.client.KClient;
import com.gokgs.client.swing.KGuiClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import org.igoweb.cgoban.CGuiClientUtil;
import org.igoweb.cgoban.ConfigWindow;
import org.igoweb.cgoban.LoginWindow;
import org.igoweb.go.sgf.FileIo;
import org.igoweb.go.sgf.IshiIo;
import org.igoweb.go.sgf.SgfException;
import org.igoweb.go.swing.GameWindow;
import org.igoweb.go.swing.sgf.CreateWindow;
import org.igoweb.go.swing.sgf.LoadWarningWindow;
import org.igoweb.go.swing.sgf.SelectFile;
import org.igoweb.go.swing.sgf.SgfGamePanel;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.client.Connector;
import org.igoweb.igoweb.client.SocketConnector;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.shared.ClientType;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.ImageViewer;
import org.igoweb.util.swing.JnlpIo;
import org.igoweb.util.swing.Prefs;

public class MainWindow
extends AFrame {
    private final JButton clientBut;
    private final JButton configBut;
    private CreateWindow setupSgfWindow = null;
    private boolean connected = false;

    public MainWindow() {
        super(Defs.getString(-382651074));
        Container topPane = this.getContentPane();
        ((JPanel)topPane).setBorder(null);
        topPane.setLayout(new OverlayLayout(topPane));
        JPanel pane = new JPanel(new GCLayout());
        int fontH = UIManager.getInt("org.igoweb.fontH");
        pane.setBorder(BorderFactory.createEmptyBorder(fontH, fontH, 0, fontH));
        pane.setOpaque(false);
        topPane.add(pane);
        topPane.add(new ImageViewer(GuiUtil.loadImage("org/igoweb/cgoban/images/greeting.png")));
        pane.add("xGrow=t,yGrow=t,xBorder=l,yBorder=l", new JLabel());
        pane.add("x=0", new JLabel());
        pane.add("x=0", new JLabel());
        this.clientBut = new JButton(Defs.getString(-382651057));
        pane.add("x=0", this.clientBut);
        this.clientBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.clientButtonPressed();
            }
        });
        JButton abut = new JButton(Defs.getString(-382651065));
        pane.add(abut);
        abut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.editButtonPressed();
            }
        });
        abut = new JButton(Defs.getString(-382651066));
        pane.add(abut);
        abut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.createButtonPressed();
            }
        });
        this.configBut = new JButton(Defs.getString(-382651069));
        this.configBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.configButtonPressed();
            }
        });
        pane.add("x=0,yBorder=0", this.configBut);
        abut = new JButton(Defs.getString(1436228516));
        pane.add(abut);
        abut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GuiUtil.loadHelp("app/main.html");
            }
        });
        abut = new JButton(Defs.getString(-382651051));
        pane.add(abut);
        abut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MainWindow.this.quitButtonPressed();
            }
        });
        String beta = Config.get("version.beta");
        JLabel label = new JLabel(Defs.getString(-382651056, new Object[]{Integer.valueOf(Config.get("version.major")), Integer.valueOf(Config.get("version.minor")), Integer.valueOf(Config.get("version.bugfix"))}) + (beta == null ? "" : "beta" + beta));
        Font boldFont = label.getFont().deriveFont(1);
        label.setFont(boldFont);
        JPanel pane2 = new JPanel(new BorderLayout());
        pane2.setOpaque(false);
        pane.add("x=0,xSpan=3,yGrow=f", pane2);
        pane2.add("Before", label);
        label = new JLabel("\u00a9 William Shubert", 4);
        label.setFont(boldFont);
        pane2.add("After", label);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension size = super.getDefaultPreferredSize();
        Insets insets = this.getInsets();
        int w = size.width - (insets.left + insets.right);
        int h = size.height - (insets.top + insets.bottom);
        if (w < h) {
            w = h;
        }
        size.width = w + insets.left + insets.right;
        size.height = w + insets.top + insets.bottom;
        return size;
    }

    public void clientButtonPressed() {
        if (!this.clientBut.isEnabled()) {
            return;
        }
        if (Config.get("version.beta") == null) {
            this.clientBut.setEnabled(false);
        }
        final LoginWindow loginWindow = new LoginWindow(this);
        loginWindow.setListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Cancel") || loginWindow.loginPanel.getUser() == null) {
                    MainWindow.this.clientBut.setEnabled(true);
                } else {
                    MainWindow.this.connected = true;
                    KGuiClient kgc = new KGuiClient(loginWindow.loginPanel.getUser(), loginWindow.loginPanel.getPassword(), JnlpIo.isAvailable() ? ClientType.JAVAWS : ClientType.STANDALONE, MainWindow.makeConnector()){

                        @Override
                        protected GuiClientUtil buildGuiClientUtil() {
                            return new CGuiClientUtil((KClient)this.getClient());
                        }
                    };
                    kgc.getClient().addListener(new EventListener(){

                        @Override
                        public void handleEvent(Event cliEvent) {
                            if (cliEvent.type == 87) {
                                MainWindow.this.connected = false;
                                MainWindow.this.clientBut.setEnabled(true);
                            }
                        }
                    });
                    kgc.go();
                }
                loginWindow.dispose();
            }
        });
        loginWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                if (!MainWindow.this.connected) {
                    MainWindow.this.clientBut.setEnabled(true);
                }
            }
        });
    }

    private void quitButtonPressed() {
        System.exit(0);
    }

    private void configButtonPressed() {
        this.configBut.setEnabled(false);
        ConfigWindow win = new ConfigWindow(this);
        win.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                MainWindow.this.configBut.setEnabled(true);
            }
        });
    }

    private void createButtonPressed() {
        if (this.setupSgfWindow != null) {
            this.setupSgfWindow.dispose();
            this.setupSgfWindow = null;
        }
        this.setupSgfWindow = new CreateWindow();
        this.setupSgfWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                if (event.getSource() == MainWindow.this.setupSgfWindow) {
                    if (MainWindow.this.setupSgfWindow.getTree() != null) {
                        new GameWindow(1096335315, null, new SgfGamePanel(new FileIo(MainWindow.this.setupSgfWindow.getTree())));
                    }
                    MainWindow.this.setupSgfWindow = null;
                }
            }
        });
    }

    private void editButtonPressed() {
        JnlpIo.FileAccessResult inResult = JnlpIo.openFile(null, new String[]{"sgf"});
        File toLoad = null;
        InputStream in = null;
        if (inResult == null) {
            toLoad = SelectFile.getFile((Component)this, Defs.getString(-382651075), (File)null, false);
        } else if (inResult.isFileSelected()) {
            toLoad = new File(inResult.getFileName());
            in = inResult.getInputStream();
        }
        if (toLoad != null || in != null) {
            MainWindow.makeSgfGameWindow(toLoad, in, this);
        }
    }

    public static GameWindow makeSgfGameWindow(File inFile, InputStream in, AFrame parent) {
        String error = "";
        try {
            if (inFile.toString().endsWith(".go")) {
                return new GameWindow(1096335315, parent, new SgfGamePanel(new FileIo(IshiIo.read(inFile))));
            }
            FileIo fileIo = new FileIo(inFile, in);
            GameWindow gameWin = new GameWindow(1096335315, parent, new SgfGamePanel(fileIo));
            LoadWarningWindow.create(fileIo.getLoadWarnings(), gameWin);
            return gameWin;
        }
        catch (SgfException excep) {
            error = excep.getMessage();
        }
        catch (IOException excep) {
            error = excep.toString();
        }
        new Errout(Defs.getString(1096335340, new Object[]{inFile, error}), parent);
        return null;
    }

    public static Connector makeConnector() {
        return new SocketConnector(Prefs.getString("n0&FI uj", Config.get("defaultHost")), Prefs.getInt("ia9sW4oV", Config.getInt("defaultPort")));
    }
}

