'\"
'\" Generated from file 'critcl\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Jean-Claude Wippler
'\" Copyright (c) Steve Landers
'\" Copyright (c) 2011-2024 Andreas Kupries
'\"
.TH "critcl" n 3\&.3\&.1 doc "C Runtime In Tcl (CriTcl)"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
critcl \- Introduction To CriTcl
.SH DESCRIPTION
.PP
Be welcome to the \fIC Runtime In Tcl\fR (short: \fICriTcl\fR), a system for embedding and using C
code from within \fITcl\fR [http://core\&.tcl-lang\&.org/tcl] scripts\&.
.PP
Adding C code to \fITcl\fR [http://core\&.tcl-lang\&.org/tcl]/\fITk\fR [http://core\&.tcl-lang\&.org/tk] has never been easier\&.
.PP
Improve performance by rewriting the performance bottlenecks in C\&.
.PP
Import the functionality of shared libraries into Tcl scripts\&.
.PP
.SH "HISTORY & MOTIVATION"
.PP
\fICriTcl\fR started life as an experiment by \fIJean-Claude Wippler\fR and was a self-contained
Tcl package to build C code into a Tcl/Tk extension on the fly\&. It was somewhat inspired
by Brian Ingerson's \fIInline\fR for \fIPerl\fR, but is considerably more lightweight\&.
.PP
It is for the last 5% to 10% when pure Tcl, which does go a long way, is not
sufficient anymore\&. I\&.e\&. for
.IP [1]
when the last bits of performance are needed,
.IP [2]
access to 3rd party libraries,
.IP [3]
hiding critical pieces of your library or application, and
.IP [4]
simply needing features provided only by C\&.
.PP
.SH OVERVIEW
To make the reader's topics of interest easy to find this documentation is roughly
organized by \fIQuadrants\fR [https://documentation\&.divio\&.com/], i\&.e\&.
.CS


            | Study           | Work
----------- + --------------- + -----------------
Practical   | \fBTutorials\fR       | \fBHow-To Guides\fR
            | (Learning)      | (Problem solving)
----------- + --------------- + -----------------
Theoretical | \fBExplanations\fR    | \fBReferences\fR
            | (Understanding) | (Knowledge)

.CE
\fINote\fR: At this point in time the documentation consists mainly of references, and
a few how-to guides\&. Tutorials and Explanations are in need of expansion, this is planned\&.
.SH "KNOWN USERS"
.IP \(bu
\fIAnKH\fR [https://core\&.tcl-lang\&.org/akupries/ankh]
.IP \(bu
\fITclYAML\fR [https://core\&.tcl\&.tk/akupries/tclyaml]
.IP \(bu
\fILinenoise\fR [https://github\&.com/andreas-kupries/tcl-linenoise]
.IP \(bu
\fIKineTcl\fR [https://core\&.tcl\&.tk/akupries/kinetcl]
.IP \(bu
\fIInotify\fR [https://chiselapp\&.com/user/andreas_kupries/repository/inotify]
.IP \(bu
\fITclMarpa\fR [https://core\&.tcl\&.tk/akupries/marpa]
.IP \(bu
\fICRIMP\fR [https://core\&.tcl\&.tk/akupries/crimp]
.PP
.SH "TUTORIALS - PRACTICAL STUDY - TO LEARN"
This section is currently empty\&.
.SH "EXPLANATIONS - THEORETICAL KNOWLEDGE - TO UNDERSTAND"
This section is currently empty\&.
.SH "HOW-TO GUIDES - PRACTICAL WORK - TO SOLVE PROBLEMS"
.IP [1]
\fIHow To Get The CriTcl Sources\fR\&.
.IP [2]
\fIHow To Install CriTcl\fR\&.
.IP [3]
\fIHow To Use CriTcl\fR - A light introduction through examples\&.
.IP [4]
\fINEW\fR: \fIHow To Adapt Critcl Packages for Tcl 9\fR\&.
.PP
.SH "REFERENCES - THEORETICAL WORK - TO GAIN KNOWLEGDE"
.IP [1]
\fIThe CriTcl License\fR
.IP [2]
\fICriTcl Releases & Changes\fR
.IP [3]
\fICriTcl Application Reference\fR
.IP [4]
\fICriTcl Package Reference\fR
.IP [5]
\fICriTcl cproc Type Reference\fR
.IP [6]
\fICriTcl - Utilities\fR
.IP [7]
\fICriTcl - C-level Utilities\fR
.IP [8]
\fICriTcl - C-level Callback Utilities\fR
.IP [9]
\fICriTcl - Wrap Support - String/Integer mapping\fR
.IP [10]
\fICriTcl - Wrap Support - Bitset en- and decoding\fR
.IP [11]
\fICriTcl - Wrap Support - Enum en- and decoding\fR
.IP [12]
\fICriTcl - Code Gen - Constant string pools\fR
.IP [13]
\fICriTcl - Code Gen - Tcl Interp Associations\fR
.IP [14]
\fICriTcl - Code Gen - C Classes\fR
.IP [15]
\fICriTcl Application Package Reference\fR
.IP [16]
\fIGuide To The CriTcl Internals\fR
.PP
.SH AUTHORS
Jean Claude Wippler, Steve Landers, Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report them at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR\&.
Ideas for enhancements you may have for either package, application,
and/or the documentation are also very welcome and should be reported
at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR as well\&.
.SH KEYWORDS
C code, Embedded C Code, calling C code from Tcl, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) Jean-Claude Wippler
Copyright (c) Steve Landers
Copyright (c) 2011-2024 Andreas Kupries

.fi
