### Copyright (C) 1995-2000 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

######################################################################
######################################################################
### Thanks to Jeppe Buk (buk@imada.sdu.dk) for creating this
### widget.
######################################################################
######################################################################


######################################################################
### This function creates a popup menu (just like menu) with the
### difference, that a "more" entry will be place at the buttom if
### more entries are use than can be located on the screen at once.
######################################################################
proc ext_optionMenu {w varName maxHeight firstValue args} {
  global  __language
  upvar #0 $varName var

  if ![info exists var] {
    set var $firstValue
  }
  menubutton $w -textvariable $varName -indicatoron 1 -menu $w.menu0 \
      -relief raised -bd 2 -highlightthickness 2 -anchor c

  # The (sub) menus
  set noMenus [expr ([llength $args]+1) / $maxHeight + 1]
  for {set j 0} {$j < $noMenus} {incr j} {
    menu $w.[buildMenuName $j] -tearoff 0
  }
  $w.menu0 add command -label $firstValue \
      -command [list set $varName $firstValue]

  set curNo 1
  foreach i $args {
    set prevMenu [expr $curNo / $maxHeight - 1]
    set curMenu [expr $curNo / $maxHeight]
    if {$curNo % $maxHeight == 0} {
      $w.[buildMenuName $prevMenu] add separator
      $w.[buildMenuName $prevMenu] add cascade -label $__language(extOptMenu,1) \
          -menu $w.[buildMenuName $curMenu]
    }
    $w.[buildMenuName $curMenu] add command -label $i \
        -command [list set $varName $i]
    incr curNo
  }
  return $w.menu
}
proc buildMenuName { no } {
  set name menu0
  for {set i 1} {$i <= $no} {incr i} {
    append name ".menu$i"
  }
  return $name
}


######################################################################
### This function calculates the number of items, which can be located
### at the screen in a menu
######################################################################
proc numOfItems {} {
  set w .__dotfile
  toplevel $w
  wm withdraw $w
  menubutton $w.a -menu $w.a.b
  menu $w.a.b
  $w.a.b add command -label "test"
  pack $w.a
  update
  set h1 [winfo reqheight $w.a.b]
  $w.a.b add command -label "test"
  update
  set h2 [winfo reqheight $w.a.b]

  set total [winfo screenheight .]

  set elmHeight [expr $h2-$h1]
  destroy $w
  return [expr ($total - ($h1-$elmHeight))/$elmHeight -1]
}

proc extOptMenu {w varName firstValue args} {
  ext_optionMenu $w $varName [numOfItems] $firstValue $args
}
