/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.bitmap.BitmapCheckerFactory;
import com.adobe.epubcheck.dtbook.DTBookCheckerFactory;
import com.adobe.epubcheck.ncx.NCXCheckerFactory;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ContentCheckerFactory;
import com.adobe.epubcheck.opf.GenericContentCheckerFactory;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OPFChecker {
    ZipFile zip;
    Report report;
    String path;
    static XMLValidator opfValidator = new XMLValidator("rng/opf.rng");
    static XMLValidator opfSchematronValidator = new XMLValidator("sch/opf.sch");
    XRefChecker xrefChecker;
    HashSet encryptedItemsSet;
    static Hashtable contentCheckerFactoryMap;

    public OPFChecker(ZipFile zip, Report report, String path) {
        this.zip = zip;
        this.report = report;
        this.path = path;
        this.xrefChecker = new XRefChecker(zip, report);
    }

    public void setEncryptedItemsSet(HashSet encryptedItemsSet) {
        this.encryptedItemsSet = encryptedItemsSet;
    }

    public void runChecks() {
        ZipEntry opfEntry = this.zip.getEntry(this.path);
        if (opfEntry == null) {
            this.report.error(null, 0, "OPF file " + this.path + " is missing");
        } else {
            OPFItem item;
            int i;
            XMLParser opfParser = new XMLParser(this.zip, this.path, this.report);
            OPFHandler opfHandler = new OPFHandler(opfParser, this.path);
            opfHandler.setEncryptedItemsSet(this.encryptedItemsSet);
            opfParser.addXMLHandler(opfHandler);
            opfParser.addValidator(opfValidator);
            opfParser.addValidator(opfSchematronValidator);
            try {
                opfParser.process();
            }
            catch (Throwable t) {
                this.report.error(this.path, -1, "Failed performing OPF Schematron tests: " + t.getMessage());
            }
            if (!opfHandler.checkUniqueIdentExists()) {
                this.report.error(this.path, -1, "unique-identifier attribute in package element must reference an existing identifier element id");
            }
            int itemCount = opfHandler.getItemCount();
            for (int i2 = 0; i2 < itemCount; ++i2) {
                OPFItem item2 = opfHandler.getItem(i2);
                try {
                    this.xrefChecker.registerResource(item2.getPath(), item2.getMimeType());
                }
                catch (IllegalArgumentException e) {
                    this.report.error(this.path, item2.getLineNumber(), e.getMessage());
                }
                this.checkItem(item2, opfHandler);
            }
            int spineItemCount = opfHandler.getSpineItemCount();
            for (i = 0; i < spineItemCount; ++i) {
                item = opfHandler.getSpineItem(i);
                this.checkSpineItem(item, opfHandler);
            }
            for (i = 0; i < itemCount; ++i) {
                item = opfHandler.getItem(i);
                this.checkItemContent(item, opfHandler);
            }
            this.xrefChecker.checkReferences();
        }
    }

    static boolean isBlessedItemType(String type) {
        return type.equals("application/xhtml+xml") || type.equals("application/x-dtbook+xml");
    }

    static boolean isDeprecatedBlessedItemType(String type) {
        return type.equals("text/x-oeb1-document") || type.equals("text/html");
    }

    static boolean isBlessedStyleType(String type) {
        return type.equals("text/css");
    }

    static boolean isDeprecatedBlessedStyleType(String type) {
        return type.equals("text/x-oeb1-css");
    }

    static boolean isBlessedImageType(String type) {
        return type.equals("image/gif") || type.equals("image/png") || type.equals("image/jpeg") || type.equals("image/svg+xml");
    }

    private void checkItem(OPFItem item, OPFHandler opfHandler) {
        OPFItem fallbackStyleItem;
        String fallbackStyle;
        OPFItem fallbackItem;
        String mimeType = item.getMimeType();
        String fallback = item.getFallback();
        if (mimeType == null || mimeType.equals("")) {
            this.report.error(this.path, item.getLineNumber(), "empty media-type attribute");
        } else if (!mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+")) {
            this.report.error(this.path, item.getLineNumber(), "invalid content for media-type attribute");
        } else if (OPFChecker.isDeprecatedBlessedItemType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType)) {
            if (opfHandler.getOpf20PackageFile() && mimeType.equals("text/html")) {
                this.report.warning(this.path, item.getLineNumber(), "text/html is not appropriate for XHTML/OPS, use application/xhtml+xml instead");
            } else if (opfHandler.getOpf12PackageFile() && mimeType.equals("text/html")) {
                this.report.warning(this.path, item.getLineNumber(), "text/html is not appropriate for OEBPS 1.2, use text/x-oeb1-document instead");
            } else if (opfHandler.getOpf20PackageFile()) {
                this.report.warning(this.path, item.getLineNumber(), "deprecated media-type '" + mimeType + "'");
            }
        }
        if (opfHandler.getOpf12PackageFile() && fallback == null) {
            if (OPFChecker.isBlessedItemType(mimeType)) {
                this.report.warning(this.path, item.getLineNumber(), "use of OPS media-type '" + mimeType + "' in OEBPS 1.2 context; use text/x-oeb1-document instead");
            } else if (OPFChecker.isBlessedStyleType(mimeType)) {
                this.report.warning(this.path, item.getLineNumber(), "use of OPS media-type '" + mimeType + "' in OEBPS 1.2 context; use text/x-oeb1-css instead");
            }
        }
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) == null) {
            this.report.error(this.path, item.getLineNumber(), "fallback item could not be found");
        }
        if ((fallbackStyle = item.getFallbackStyle()) != null && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle)) == null) {
            this.report.error(this.path, item.getLineNumber(), "fallback-style item could not be found");
        }
    }

    private void checkItemContent(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        String path = item.getPath();
        if (mimeType != null) {
            ContentCheckerFactory checkerFactory = item.isNcx() ? NCXCheckerFactory.getInstance() : (ContentCheckerFactory)contentCheckerFactoryMap.get(mimeType);
            if (checkerFactory == null) {
                checkerFactory = GenericContentCheckerFactory.getInstance();
            }
            if (checkerFactory != null) {
                ContentChecker checker = checkerFactory.newInstance(this.zip, this.report, path, mimeType, this.xrefChecker);
                checker.runChecks();
            }
        }
    }

    private void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (mimeType != null) {
            if (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType) || OPFChecker.isBlessedImageType(mimeType)) {
                this.report.error(this.path, item.getLineNumber(), "'" + mimeType + "' is not a permissible spine media-type");
            } else if (!(OPFChecker.isBlessedItemType(mimeType) || OPFChecker.isDeprecatedBlessedItemType(mimeType) || this.checkItemFallbacks(item, opfHandler))) {
                this.report.error(this.path, item.getLineNumber(), "non-standard media-type '" + mimeType + "' with no fallback");
            }
        }
    }

    private boolean checkItemFallbacks(OPFItem item, OPFHandler opfHandler) {
        String mimeType;
        OPFItem fallbackStyleItem;
        String fallbackStyle;
        String mimeType2;
        OPFItem fallbackItem;
        String fallback = item.getFallback();
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) != null && (mimeType2 = fallbackItem.getMimeType()) != null) {
            if (OPFChecker.isBlessedItemType(mimeType2) || OPFChecker.isDeprecatedBlessedItemType(mimeType2)) {
                return true;
            }
            if (this.checkItemFallbacks(item, opfHandler)) {
                return true;
            }
        }
        return (fallbackStyle = item.getFallbackStyle()) != null && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle)) != null && (mimeType = fallbackStyleItem.getMimeType()) != null && (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType));
    }

    static {
        Hashtable<String, ContentCheckerFactory> map = new Hashtable<String, ContentCheckerFactory>();
        map.put("application/xhtml+xml", OPSCheckerFactory.getInstance());
        map.put("text/html", OPSCheckerFactory.getInstance());
        map.put("text/x-oeb1-document", OPSCheckerFactory.getInstance());
        map.put("image/jpeg", BitmapCheckerFactory.getInstance());
        map.put("image/gif", BitmapCheckerFactory.getInstance());
        map.put("image/png", BitmapCheckerFactory.getInstance());
        map.put("image/svg+xml", OPSCheckerFactory.getInstance());
        map.put("application/x-dtbook+xml", DTBookCheckerFactory.getInstance());
        contentCheckerFactoryMap = map;
    }
}

