/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.CombineSchema;
import com.thaiopensource.relaxng.impl.FeasibleIdTypeMapSchema;
import com.thaiopensource.relaxng.impl.FeasibleTransform;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.IdTypeMapBuilder;
import com.thaiopensource.relaxng.impl.IdTypeMapSchema;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternSchema;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class SchemaReaderImpl
implements SchemaReader {
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.XML_READER_CREATOR, ValidateProperty.ERROR_HANDLER, RngProperty.DATATYPE_LIBRARY_FACTORY, RngProperty.CHECK_ID_IDREF, RngProperty.FEASIBLE, NrlProperty.ATTRIBUTES_SCHEMA};

    public Schema createSchema(InputSource in, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        SchemaPatternBuilder spb = new SchemaPatternBuilder();
        XMLReaderCreator xrc = ValidateProperty.XML_READER_CREATOR.get(properties);
        ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(properties);
        DatatypeLibraryFactory dlf = RngProperty.DATATYPE_LIBRARY_FACTORY.get(properties);
        if (dlf == null) {
            dlf = new DatatypeLibraryLoader();
        }
        Pattern start = SchemaBuilderImpl.parse(this.createParseable(xrc, in, eh), eh, dlf, spb, properties.contains(NrlProperty.ATTRIBUTES_SCHEMA));
        return SchemaReaderImpl.wrapPattern(start, spb, properties);
    }

    public Option getOption(String uri) {
        return RngProperty.getOption(uri);
    }

    static Schema wrapPattern(Pattern start, SchemaPatternBuilder spb, PropertyMap properties) throws SAXException, IncorrectSchemaException {
        if ((properties = AbstractSchema.filterProperties(properties, supportedPropertyIds)).contains(RngProperty.FEASIBLE)) {
            start = FeasibleTransform.transform(spb, start);
        }
        AbstractSchema schema = new PatternSchema(spb, start, properties);
        if (spb.hasIdTypes() && properties.contains(RngProperty.CHECK_ID_IDREF)) {
            ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(properties);
            IdTypeMap idTypeMap = new IdTypeMapBuilder(eh, start).getIdTypeMap();
            if (idTypeMap == null) {
                throw new IncorrectSchemaException();
            }
            AbstractSchema idSchema = properties.contains(RngProperty.FEASIBLE) ? new FeasibleIdTypeMapSchema(idTypeMap, properties) : new IdTypeMapSchema(idTypeMap, properties);
            schema = new CombineSchema(schema, idSchema, properties);
        }
        return schema;
    }

    protected abstract Parseable createParseable(XMLReaderCreator var1, InputSource var2, ErrorHandler var3);
}

