/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UriOrFile {
    private UriOrFile() {
    }

    public static String toUri(String uriOrFile) {
        if (!UriOrFile.hasScheme(uriOrFile)) {
            try {
                return UriOrFile.fileToUri(uriOrFile);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uriOrFile;
    }

    private static boolean hasScheme(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        if (!UriOrFile.isAlpha(str.charAt(0))) {
            return false;
        }
        block4: for (int i = 1; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case ':': {
                    return i != 1;
                }
                case '+': 
                case '-': {
                    continue block4;
                }
                default: {
                    if (UriOrFile.isAlnum(c)) continue block4;
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriOrFile.isAlpha(c) || '0' <= c && c <= '9';
    }

    public static String fileToUri(String file) throws MalformedURLException {
        return UriOrFile.fileToUri(new File(file));
    }

    public static String fileToUri(File file) throws MalformedURLException {
        String path = file.getAbsolutePath().replace(File.separatorChar, '/');
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        return new URL("file", "", path).toString();
    }

    public static String uriToUriOrFile(String uri) {
        int nSlashes;
        if (!uri.startsWith("file:")) {
            return uri;
        }
        uri = uri.substring(5);
        for (nSlashes = 0; nSlashes < uri.length() && uri.charAt(nSlashes) == '/'; ++nSlashes) {
        }
        File f = new File(uri.substring(nSlashes).replace('/', File.separatorChar));
        if (f.isAbsolute()) {
            return f.toString();
        }
        return uri.replace('/', File.separatorChar);
    }

    public static void main(String[] args) {
        System.err.println(UriOrFile.uriToUriOrFile(args[0]));
    }
}

