/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.constant.ConstantClass;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceStringBuxxxerVisitor {
    private ConstantPool constants;

    public ReplaceStringBuxxxerVisitor(ConstantPool constants) {
        this.constants = constants;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                Instruction i = this.match(al.arrayref);
                if (i == null) {
                    this.visit(al.arrayref);
                    break;
                }
                al.arrayref = i;
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                Instruction i = this.match(ali.arrayref);
                if (i == null) {
                    this.visit(ali.arrayref);
                } else {
                    ali.arrayref = i;
                }
                i = this.match(ali.indexref);
                if (i == null) {
                    this.visit(ali.indexref);
                    break;
                }
                ali.indexref = i;
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                Instruction i = this.match(asi.arrayref);
                if (i == null) {
                    this.visit(asi.arrayref);
                } else {
                    asi.arrayref = i;
                }
                i = this.match(asi.indexref);
                if (i == null) {
                    this.visit(asi.indexref);
                } else {
                    asi.indexref = i;
                }
                i = this.match(asi.valueref);
                if (i == null) {
                    this.visit(asi.valueref);
                    break;
                }
                asi.valueref = i;
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                Instruction i = this.match(ai.test);
                if (i == null) {
                    this.visit(ai.test);
                } else {
                    ai.test = i;
                }
                if (ai.msg == null) break;
                i = this.match(ai.msg);
                if (i == null) {
                    this.visit(ai.msg);
                    break;
                }
                ai.msg = i;
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                Instruction i = this.match(ai.value1);
                if (i == null) {
                    this.visit(ai.value1);
                } else {
                    ai.value1 = i;
                }
                i = this.match(ai.value2);
                if (i == null) {
                    this.visit(ai.value2);
                    break;
                }
                ai.value2 = i;
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                this.visit(aThrow.value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                Instruction i = this.match(boi.value1);
                if (i == null) {
                    this.visit(boi.value1);
                } else {
                    boi.value1 = i;
                }
                i = this.match(boi.value2);
                if (i == null) {
                    this.visit(boi.value2);
                    break;
                }
                boi.value2 = i;
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                Instruction i = this.match(uoi.value);
                if (i == null) {
                    this.visit(uoi.value);
                    break;
                }
                uoi.value = i;
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                Instruction i = this.match(dupStore.objectref);
                if (i == null) {
                    this.visit(dupStore.objectref);
                    break;
                }
                dupStore.objectref = i;
                break;
            }
            case 192: {
                CheckCast cc = (CheckCast)instruction;
                Instruction i = this.match(cc.objectref);
                if (i == null) {
                    this.visit(cc.objectref);
                    break;
                }
                cc.objectref = i;
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                Instruction i = this.match(ci.value);
                if (i == null) {
                    this.visit(ci.value);
                    break;
                }
                ci.value = i;
                break;
            }
            case 260: 
            case 262: {
                IfInstruction ifInstruction = (IfInstruction)instruction;
                Instruction i = this.match(ifInstruction.value);
                if (i == null) {
                    this.visit(ifInstruction.value);
                    break;
                }
                ifInstruction.value = i;
                break;
            }
            case 261: {
                IfCmp ifCmpInstruction = (IfCmp)instruction;
                Instruction i = this.match(ifCmpInstruction.value1);
                if (i == null) {
                    this.visit(ifCmpInstruction.value1);
                } else {
                    ifCmpInstruction.value1 = i;
                }
                i = this.match(ifCmpInstruction.value2);
                if (i == null) {
                    this.visit(ifCmpInstruction.value2);
                    break;
                }
                ifCmpInstruction.value2 = i;
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                Instruction i = this.match(instanceOf.objectref);
                if (i == null) {
                    this.visit(instanceOf.objectref);
                    break;
                }
                instanceOf.objectref = i;
                break;
            }
            case 284: {
                ComplexConditionalBranchInstruction complexIf = (ComplexConditionalBranchInstruction)instruction;
                List<Instruction> branchList = complexIf.instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 180: {
                GetField getField = (GetField)instruction;
                Instruction i = this.match(getField.objectref);
                if (i == null) {
                    this.visit(getField.objectref);
                    break;
                }
                getField.objectref = i;
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                Instruction i = this.match(insi.objectref);
                if (i == null) {
                    this.visit(insi.objectref);
                } else {
                    insi.objectref = i;
                }
                this.replaceInArgs(insi.args);
                break;
            }
            case 184: 
            case 274: {
                this.replaceInArgs(((InvokeInstruction)instruction).args);
                break;
            }
            case 171: {
                LookupSwitch lookupSwitch = (LookupSwitch)instruction;
                Instruction i = this.match(lookupSwitch.key);
                if (i == null) {
                    this.visit(lookupSwitch.key);
                    break;
                }
                lookupSwitch.key = i;
                break;
            }
            case 197: {
                MultiANewArray multiANewArray = (MultiANewArray)instruction;
                Instruction[] dimensions = multiANewArray.dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    Instruction ins = this.match(dimensions[i]);
                    if (ins == null) {
                        this.visit(dimensions[i]);
                    } else {
                        dimensions[i] = ins;
                    }
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                Instruction i = this.match(newArray.dimension);
                if (i == null) {
                    this.visit(newArray.dimension);
                    break;
                }
                newArray.dimension = i;
                break;
            }
            case 189: {
                ANewArray newArray = (ANewArray)instruction;
                Instruction i = this.match(newArray.dimension);
                if (i == null) {
                    this.visit(newArray.dimension);
                    break;
                }
                newArray.dimension = i;
                break;
            }
            case 87: {
                this.visit(((Pop)instruction).objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                Instruction i = this.match(putField.objectref);
                if (i == null) {
                    this.visit(putField.objectref);
                } else {
                    putField.objectref = i;
                }
                i = this.match(putField.valueref);
                if (i == null) {
                    this.visit(putField.valueref);
                    break;
                }
                putField.valueref = i;
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                Instruction i = this.match(putStatic.valueref);
                if (i == null) {
                    this.visit(putStatic.valueref);
                    break;
                }
                putStatic.valueref = i;
                break;
            }
            case 273: {
                ReturnInstruction returnInstruction = (ReturnInstruction)instruction;
                Instruction i = this.match(returnInstruction.valueref);
                if (i == null) {
                    this.visit(returnInstruction.valueref);
                    break;
                }
                returnInstruction.valueref = i;
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                Instruction i = this.match(storeInstruction.valueref);
                if (i == null) {
                    this.visit(storeInstruction.valueref);
                    break;
                }
                storeInstruction.valueref = i;
                break;
            }
            case 170: {
                TableSwitch tableSwitch = (TableSwitch)instruction;
                Instruction i = this.match(tableSwitch.key);
                if (i == null) {
                    this.visit(tableSwitch.key);
                    break;
                }
                tableSwitch.key = i;
                break;
            }
            case 280: {
                TernaryOpStore tosInstruction = (TernaryOpStore)instruction;
                Instruction i = this.match(tosInstruction.objectref);
                if (i == null) {
                    this.visit(tosInstruction.objectref);
                    break;
                }
                tosInstruction.objectref = i;
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                Instruction i = this.match(to.value1);
                if (i == null) {
                    this.visit(to.value1);
                } else {
                    to.value1 = i;
                }
                i = this.match(to.value2);
                if (i == null) {
                    this.visit(to.value2);
                    break;
                }
                to.value2 = i;
                break;
            }
            case 194: {
                MonitorEnter meInstruction = (MonitorEnter)instruction;
                Instruction i = this.match(meInstruction.objectref);
                if (i == null) {
                    this.visit(meInstruction.objectref);
                    break;
                }
                meInstruction.objectref = i;
                break;
            }
            case 195: {
                MonitorExit meInstruction = (MonitorExit)instruction;
                Instruction i = this.match(meInstruction.objectref);
                if (i == null) {
                    this.visit(meInstruction.objectref);
                    break;
                }
                meInstruction.objectref = i;
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iaInstruction = (InitArrayInstruction)instruction;
                Instruction i = this.match(iaInstruction.newArray);
                if (i == null) {
                    this.visit(iaInstruction.newArray);
                } else {
                    iaInstruction.newArray = i;
                }
                int index = iaInstruction.values.size() - 1;
                while (index >= 0) {
                    i = this.match(iaInstruction.values.get(index));
                    if (i == null) {
                        this.visit(iaInstruction.values.get(index));
                    } else {
                        iaInstruction.values.set(index, i);
                    }
                    --index;
                }
                break;
            }
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 277: 
            case 278: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not replace StringBuxxxer in " + instruction.getClass().getName() + " " + instruction.opcode);
            }
        }
    }

    private void replaceInArgs(List<Instruction> args) {
        if (args.size() > 0) {
            int i = args.size() - 1;
            while (i >= 0) {
                Instruction ins = this.match(args.get(i));
                if (ins == null) {
                    this.visit(args.get(i));
                } else {
                    args.set(i, ins);
                }
                --i;
            }
        }
    }

    private Instruction match(Instruction i) {
        if (i.opcode == 182) {
            Invokevirtual iv = (Invokevirtual)i;
            ConstantMethodref cmr = this.constants.getConstantMethodref(iv.index);
            ConstantClass cc = this.constants.getConstantClass(cmr.class_index);
            if (cc.name_index == this.constants.stringBufferClassNameIndex || cc.name_index == this.constants.stringBuilderClassNameIndex) {
                ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.name_and_type_index);
                if (cnat.name_index == this.constants.toStringIndex) {
                    return this.match(iv.objectref, cmr.class_index);
                }
            }
        }
        return null;
    }

    private Instruction match(Instruction i, int classIndex) {
        if (i.opcode == 182) {
            InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)i;
            ConstantMethodref cmr = this.constants.getConstantMethodref(insi.index);
            if (cmr.class_index == classIndex) {
                ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.name_and_type_index);
                if (cnat.name_index == this.constants.appendIndex && insi.args.size() == 1) {
                    Instruction result = this.match(insi.objectref, cmr.class_index);
                    if (result == null) {
                        return (Instruction)insi.args.get(0);
                    }
                    return new BinaryOperatorInstruction(267, i.offset, i.lineNumber, 4, "Ljava/lang/String;", "+", result, (Instruction)insi.args.get(0));
                }
            }
        } else if (i.opcode == 274) {
            InvokeNew in = (InvokeNew)i;
            ConstantMethodref cmr = this.constants.getConstantMethodref(in.index);
            if (cmr.class_index == classIndex && in.args.size() == 1) {
                Instruction arg0 = (Instruction)in.args.get(0);
                if (arg0.opcode == 184) {
                    Invokestatic is = (Invokestatic)arg0;
                    cmr = this.constants.getConstantMethodref(is.index);
                    ConstantClass cc = this.constants.getConstantClass(cmr.class_index);
                    if (cc.name_index == this.constants.stringClassNameIndex) {
                        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.name_and_type_index);
                        if (cnat.name_index == this.constants.valueOfIndex && is.args.size() == 1) {
                            return (Instruction)is.args.get(0);
                        }
                    }
                }
                return arg0;
            }
        }
        return null;
    }
}

