/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.Ret;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.process.analyzer.instruction.bytecode.factory.UnexpectedOpcodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WideFactory
extends InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset + 1] & 0xFF;
        int index = (code[offset + 2] & 0xFF) << 8 | code[offset + 3] & 0xFF;
        if (opcode == 132) {
            short count = (short)((code[offset + 4] & 0xFF) << 8 | code[offset + 5] & 0xFF);
            IInc instruction = new IInc(opcode, offset, lineNumber, index, count);
            list.add(instruction);
            listForAnalyze.add(instruction);
            return 5;
        }
        if (opcode == 169) {
            list.add(new Ret(opcode, offset, lineNumber, index));
        } else {
            LoadInstruction instruction = null;
            switch (opcode) {
                case 21: {
                    instruction = new LoadInstruction(21, offset, lineNumber, index, "I");
                    stack.push(instruction);
                    break;
                }
                case 23: {
                    instruction = new LoadInstruction(268, offset, lineNumber, index, "F");
                    stack.push(instruction);
                    break;
                }
                case 25: {
                    instruction = new ALoad(25, offset, lineNumber, index);
                    stack.push(instruction);
                    break;
                }
                case 22: {
                    instruction = new LoadInstruction(268, offset, lineNumber, index, "J");
                    stack.push(instruction);
                    break;
                }
                case 24: {
                    instruction = new LoadInstruction(268, offset, lineNumber, index, "D");
                    stack.push(instruction);
                    break;
                }
                case 54: {
                    instruction = new StoreInstruction(54, offset, lineNumber, index, "I", stack.pop());
                    list.add(instruction);
                    break;
                }
                case 56: {
                    instruction = new StoreInstruction(269, offset, lineNumber, index, "F", stack.pop());
                    list.add(instruction);
                    break;
                }
                case 58: {
                    instruction = new AStore(58, offset, lineNumber, index, stack.pop());
                    list.add(instruction);
                    break;
                }
                case 55: {
                    instruction = new StoreInstruction(269, offset, lineNumber, index, "J", stack.pop());
                    list.add(instruction);
                    break;
                }
                case 57: {
                    instruction = new StoreInstruction(269, offset, lineNumber, index, "D", stack.pop());
                    list.add(instruction);
                    break;
                }
                default: {
                    throw new UnexpectedOpcodeException(opcode);
                }
            }
            listForAnalyze.add(instruction);
        }
        return 2;
    }
}

