/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.constant.ConstantFieldref;
import jd.core.model.classfile.constant.ConstantMethodref;
import jd.core.model.classfile.constant.ConstantNameAndType;
import jd.core.model.classfile.constant.ConstantString;
import jd.core.model.classfile.constant.ConstantValue;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Ldc;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotClass118BReconstructor {
    public static void Reconstruct(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list) {
        int i = list.size();
        if (i < 5) {
            return;
        }
        i -= 4;
        ConstantPool constants = classFile.getConstantPool();
        block0: while (i-- > 0) {
            String nameField;
            List<Instruction> catchInstructions;
            Instruction instruction = list.get(i);
            if (instruction.opcode != 264) continue;
            DupStore ds = (DupStore)instruction;
            if (ds.objectref.opcode != 178) continue;
            GetStatic gs = (GetStatic)ds.objectref;
            ConstantFieldref cfr = constants.getConstantFieldref(gs.index);
            if (cfr.class_index != classFile.getThisClassIndex()) continue;
            instruction = list.get(i + 1);
            if (instruction.opcode != 262) continue;
            IfInstruction ii = (IfInstruction)instruction;
            if (ii.value.opcode != 263 || ds.offset != ii.value.offset) continue;
            instruction = list.get(i + 2);
            if (instruction.opcode != 87) continue;
            Pop pop = (Pop)instruction;
            if (pop.objectref.opcode != 263 || ds.offset != pop.objectref.offset) continue;
            instruction = list.get(i + 3);
            if (instruction.opcode != 318) continue;
            FastTry ft = (FastTry)instruction;
            if (ft.finallyInstructions != null || ft.instructions.size() != 1 || ft.catches.size() != 1 || (catchInstructions = ft.catches.get((int)0).instructions).size() != 1 || catchInstructions.get((int)0).opcode != 191) continue;
            instruction = (Instruction)ft.instructions.get(0);
            if (instruction.opcode != 280) continue;
            TernaryOpStore tos = (TernaryOpStore)instruction;
            if (tos.objectref.opcode != 265) continue;
            AssignmentInstruction ai = (AssignmentInstruction)tos.objectref;
            if (ai.value2.opcode != 184) continue;
            Invokestatic is = (Invokestatic)ai.value2;
            if (is.args.size() != 1) continue;
            instruction = (Instruction)is.args.get(0);
            if (instruction.opcode != 18) continue;
            ConstantNameAndType cnatField = constants.getConstantNameAndType(cfr.name_and_type_index);
            String signature = constants.getConstantUtf8(cnatField.descriptor_index);
            if (!"Ljava/lang/Class;".equals(signature) || !(nameField = constants.getConstantUtf8(cnatField.name_index)).startsWith("class$")) continue;
            ConstantMethodref cmr = constants.getConstantMethodref(is.index);
            String className = constants.getConstantClassName(cmr.class_index);
            if (!className.equals("java/lang/Class")) continue;
            ConstantNameAndType cnatMethod = constants.getConstantNameAndType(cmr.name_and_type_index);
            String nameMethod = constants.getConstantUtf8(cnatMethod.name_index);
            if (!nameMethod.equals("forName")) continue;
            Ldc ldc = (Ldc)instruction;
            ConstantValue cv = constants.getConstantValue(ldc.index);
            if (cv.tag != 8) continue;
            ConstantString cs = (ConstantString)cv;
            String dotClassName = constants.getConstantUtf8(cs.string_index);
            String internalName = dotClassName.replace('.', '/');
            referenceMap.add(internalName);
            int index = constants.addConstantUtf8(internalName);
            index = constants.addConstantClass(index);
            ldc = new Ldc(18, ii.offset, ii.lineNumber, index);
            ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(ds, ldc);
            visitor.visit(list.get(i + 4));
            list.remove(i + 3);
            list.remove(i + 2);
            list.remove(i + 1);
            list.remove(i);
            Field[] fields = classFile.getFields();
            int j = fields.length;
            while (j-- > 0) {
                Field field = fields[j];
                if (field.name_index != cnatField.name_index) continue;
                field.access_flags |= 0x1000;
                continue block0;
            }
        }
    }
}

