/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.layouter;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.layout.block.GenericExtendsSuperInterfacesLayoutBlock;
import jd.core.model.layout.block.GenericExtendsSuperTypeLayoutBlock;
import jd.core.model.layout.block.GenericImplementsInterfacesLayoutBlock;
import jd.core.model.layout.block.GenericTypeNameLayoutBlock;
import jd.core.model.layout.block.LayoutBlock;
import jd.core.util.CharArrayUtil;
import jd.core.util.SignatureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureLayouter {
    public static boolean CreateLayoutBlocksForClassSignature(ClassFile classFile, String signature, List<LayoutBlock> layoutBlockList) {
        boolean displayExtendsOrImplementsFlag = false;
        char[] caSignature = signature.toCharArray();
        int length = caSignature.length;
        int index = 0;
        layoutBlockList.add(new GenericTypeNameLayoutBlock(classFile, signature));
        index = SignatureLayouter.SkipGenerics(caSignature, length, index);
        int newIndex = SignatureUtil.SkipSignature(caSignature, length, index);
        if ((classFile.access_flags & 0x4200) == 0 && !SignatureLayouter.IsObjectClass(caSignature, index, newIndex)) {
            displayExtendsOrImplementsFlag = true;
            layoutBlockList.add(new GenericExtendsSuperTypeLayoutBlock(classFile, caSignature, index));
        }
        if (newIndex < length) {
            displayExtendsOrImplementsFlag = true;
            if ((classFile.access_flags & 0x200) != 0) {
                layoutBlockList.add(new GenericExtendsSuperInterfacesLayoutBlock(classFile, caSignature, newIndex));
            } else {
                layoutBlockList.add(new GenericImplementsInterfacesLayoutBlock(classFile, caSignature, newIndex));
            }
        }
        return displayExtendsOrImplementsFlag;
    }

    private static int SkipGenerics(char[] caSignature, int length, int index) {
        if (caSignature[index] == '<') {
            int depth = 1;
            while (index < length) {
                char c;
                if ((c = caSignature[++index]) == '<') {
                    ++depth;
                    continue;
                }
                if (c != '>') continue;
                if (depth > 1) {
                    --depth;
                    continue;
                }
                ++index;
                break;
            }
        }
        return index;
    }

    private static boolean IsObjectClass(char[] caSignature, int beginIndex, int endIndex) {
        return CharArrayUtil.Substring(caSignature, beginIndex, endIndex).equals("Ljava/lang/Object;");
    }
}

