/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.jd.gui.service.type.ClassFileTypeFactoryProvider;
import org.jd.gui.spi.TypeFactory;

public abstract class AbstractTypeFactoryProvider
implements TypeFactory {
    protected List<String> externalSelectors;
    protected Pattern externalPathPattern;
    protected static final ImageIcon ABSTRACT_OVERLAY_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/abstract_ovr.png"));
    protected static final ImageIcon FINAL_OVERLAY_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/final_ovr.png"));
    protected static final ImageIcon STATIC_OVERLAY_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/static_ovr.png"));
    protected static final ImageIcon CLASS_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/class_default_obj.png"));
    protected static final ImageIcon PUBLIC_CLASS_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/class_obj.png"));
    protected static final ImageIcon PROTECTED_CLASS_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/class_protected_obj.png"));
    protected static final ImageIcon PRIVATE_CLASS_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/class_private_obj.png"));
    protected static final ImageIcon INTERFACE_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/int_default_obj.png"));
    protected static final ImageIcon PUBLIC_INTERFACE_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/int_obj.png"));
    protected static final ImageIcon PROTECTED_INTERFACE_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/int_protected_obj.png"));
    protected static final ImageIcon PRIVATE_INTERFACE_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/int_private_obj.png"));
    protected static final ImageIcon ANNOTATION_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/annotation_obj.png"));
    protected static final ImageIcon ENUM_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/enum_obj.png"));
    protected static final ImageIcon FIELD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/field_default_obj.png"));
    protected static final ImageIcon PUBLIC_FIELD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/field_public_obj.png"));
    protected static final ImageIcon PROTECTED_FIELD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/field_protected_obj.png"));
    protected static final ImageIcon PRIVATE_FIELD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/field_private_obj.png"));
    protected static final ImageIcon METHOD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/methdef_obj.png"));
    protected static final ImageIcon PUBLIC_METHOD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/methpub_obj.png"));
    protected static final ImageIcon PROTECTED_METHOD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/methpro_obj.png"));
    protected static final ImageIcon PRIVATE_METHOD_ICON = new ImageIcon(ClassFileTypeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/methpri_obj.png"));
    protected static final ImageIcon[] DEFAULT_CLASS_ICONS = new ImageIcon[]{CLASS_ICON, PUBLIC_CLASS_ICON, PROTECTED_CLASS_ICON, PRIVATE_CLASS_ICON};
    protected static final ImageIcon[] DEFAULT_INTERFACE_ICONS = new ImageIcon[]{INTERFACE_ICON, PUBLIC_INTERFACE_ICON, PROTECTED_INTERFACE_ICON, PRIVATE_INTERFACE_ICON};
    protected static final ImageIcon[] DEFAULT_FIELD_ICONS = new ImageIcon[]{FIELD_ICON, PUBLIC_FIELD_ICON, PROTECTED_FIELD_ICON, PRIVATE_FIELD_ICON};
    protected static final ImageIcon[] DEFAULT_METHOD_ICONS = new ImageIcon[]{METHOD_ICON, PUBLIC_METHOD_ICON, PROTECTED_METHOD_ICON, PRIVATE_METHOD_ICON};
    protected static final ImageIcon[] STATIC_CLASS_ICONS = AbstractTypeFactoryProvider.mergeIcons(DEFAULT_CLASS_ICONS, STATIC_OVERLAY_ICON, 100, 0);
    protected static final ImageIcon[] STATIC_INTERFACE_ICONS = AbstractTypeFactoryProvider.mergeIcons(DEFAULT_INTERFACE_ICONS, STATIC_OVERLAY_ICON, 100, 0);
    protected static final ImageIcon[] STATIC_FIELD_ICONS = AbstractTypeFactoryProvider.mergeIcons(DEFAULT_FIELD_ICONS, STATIC_OVERLAY_ICON, 100, 0);
    protected static final ImageIcon[] STATIC_METHOD_ICONS = AbstractTypeFactoryProvider.mergeIcons(DEFAULT_METHOD_ICONS, STATIC_OVERLAY_ICON, 100, 0);
    protected static final ImageIcon[] FINAL_STATIC_CLASS_ICONS = AbstractTypeFactoryProvider.mergeIcons(STATIC_CLASS_ICONS, FINAL_OVERLAY_ICON, 0, 0);
    protected static final ImageIcon[] FINAL_STATIC_INTERFACE_ICONS = AbstractTypeFactoryProvider.mergeIcons(STATIC_INTERFACE_ICONS, FINAL_OVERLAY_ICON, 0, 0);
    protected static final ImageIcon[] FINAL_STATIC_FIELD_ICONS = AbstractTypeFactoryProvider.mergeIcons(STATIC_FIELD_ICONS, FINAL_OVERLAY_ICON, 0, 0);
    protected static final ImageIcon[] FINAL_STATIC_METHOD_ICONS = AbstractTypeFactoryProvider.mergeIcons(STATIC_METHOD_ICONS, FINAL_OVERLAY_ICON, 0, 0);
    protected static final ImageIcon[] CLASS_ICONS = AbstractTypeFactoryProvider.mergeIcons(FINAL_STATIC_CLASS_ICONS, ABSTRACT_OVERLAY_ICON, 0, 100);
    protected static final ImageIcon[] INTERFACE_ICONS = AbstractTypeFactoryProvider.mergeIcons(FINAL_STATIC_INTERFACE_ICONS, ABSTRACT_OVERLAY_ICON, 0, 100);
    protected static final ImageIcon[] FIELD_ICONS = AbstractTypeFactoryProvider.mergeIcons(FINAL_STATIC_FIELD_ICONS, ABSTRACT_OVERLAY_ICON, 0, 100);
    protected static final ImageIcon[] METHOD_ICONS = AbstractTypeFactoryProvider.mergeIcons(FINAL_STATIC_METHOD_ICONS, ABSTRACT_OVERLAY_ICON, 0, 100);

    public AbstractTypeFactoryProvider() {
        Properties properties = new Properties();
        Class<?> clazz = this.getClass();
        try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".properties");){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(properties);
    }

    protected void init(Properties properties) {
        String selectors = properties.getProperty("selectors");
        this.externalSelectors = selectors == null ? null : Arrays.asList(selectors.split(","));
        String pathRegExp = properties.getProperty("pathRegExp");
        this.externalPathPattern = pathRegExp == null ? null : Pattern.compile(pathRegExp);
    }

    protected List<String> getExternalSelectors() {
        return this.externalSelectors;
    }

    protected Pattern getExternalPathPattern() {
        return this.externalPathPattern;
    }

    @Override
    public String[] getSelectors() {
        return this.externalSelectors == null ? null : this.externalSelectors.toArray(new String[this.externalSelectors.size()]);
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }

    protected static int writeSignature(StringBuffer sb, String descriptor, int length, int index, boolean varargsFlag) {
        while (true) {
            int dimensionLength = 0;
            if (descriptor.charAt(index) == '[') {
                ++dimensionLength;
                while (++index < length) {
                    if (descriptor.charAt(index) == 'L' && index + 1 < length && descriptor.charAt(index + 1) == '[') {
                        ++index;
                        --length;
                        ++dimensionLength;
                        continue;
                    }
                    if (descriptor.charAt(index) != '[') break;
                    ++dimensionLength;
                }
            }
            switch (descriptor.charAt(index)) {
                case 'B': {
                    sb.append("byte");
                    ++index;
                    break;
                }
                case 'C': {
                    sb.append("char");
                    ++index;
                    break;
                }
                case 'D': {
                    sb.append("double");
                    ++index;
                    break;
                }
                case 'F': {
                    sb.append("float");
                    ++index;
                    break;
                }
                case 'I': {
                    sb.append("int");
                    ++index;
                    break;
                }
                case 'J': {
                    sb.append("long");
                    ++index;
                    break;
                }
                case '.': 
                case 'L': {
                    int beginIndex = ++index;
                    int c = 46;
                    while (index < length && (c = (int)descriptor.charAt(index)) != 59 && c != 60) {
                        ++index;
                    }
                    String internalClassName = descriptor.substring(beginIndex, index);
                    int lastPackageSeparatorIndex = internalClassName.lastIndexOf(47);
                    if (lastPackageSeparatorIndex >= 0) {
                        internalClassName = internalClassName.substring(lastPackageSeparatorIndex + 1);
                    }
                    sb.append(internalClassName.replace('$', '.'));
                    if (c == 60) {
                        sb.append('<');
                        index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index + 1, false);
                        while (descriptor.charAt(index) != '>') {
                            sb.append(", ");
                            index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index, false);
                        }
                        sb.append('>');
                        ++index;
                    }
                    if (descriptor.charAt(index) != ';') break;
                    ++index;
                    break;
                }
                case 'S': {
                    sb.append("short");
                    ++index;
                    break;
                }
                case 'T': {
                    int beginIndex = ++index;
                    index = descriptor.substring(beginIndex, length).indexOf(59);
                    sb.append(descriptor.substring(beginIndex, index));
                    ++index;
                    break;
                }
                case 'V': {
                    sb.append("void");
                    ++index;
                    break;
                }
                case 'Z': {
                    sb.append("boolean");
                    ++index;
                    break;
                }
                case '-': {
                    sb.append("? super ");
                    index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index + 1, false);
                    break;
                }
                case '+': {
                    sb.append("? extends ");
                    index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index + 1, false);
                    break;
                }
                case '*': {
                    sb.append('?');
                    ++index;
                    break;
                }
                case 'X': 
                case 'Y': {
                    sb.append("int");
                    ++index;
                    break;
                }
                default: {
                    throw new RuntimeException("SignatureWriter.WriteSignature: invalid signature '" + descriptor + "'");
                }
            }
            if (varargsFlag) {
                if (dimensionLength > 0) {
                    while (--dimensionLength > 0) {
                        sb.append("[]");
                    }
                    sb.append("...");
                }
            } else {
                while (dimensionLength-- > 0) {
                    sb.append("[]");
                }
            }
            if (index >= length || descriptor.charAt(index) != '.') break;
            sb.append('.');
        }
        return index;
    }

    protected static void writeMethodSignature(StringBuffer sb, int typeAccess, int methodAccess, boolean isInnerClass, String constructorName, String methodName, String descriptor) {
        if (methodName.equals("<clinit>")) {
            sb.append("{...}");
        } else {
            int index;
            boolean isAConstructor = methodName.equals("<init>");
            if (isAConstructor) {
                sb.append(constructorName);
            } else {
                sb.append(methodName);
            }
            int length = descriptor.length();
            for (index = 0; index < length && descriptor.charAt(index) != '('; ++index) {
            }
            if (descriptor.charAt(index) != '(') {
                throw new RuntimeException("Signature format exception: '" + descriptor + "'");
            }
            sb.append('(');
            if (descriptor.charAt(++index) != ')') {
                if (isAConstructor && isInnerClass && (typeAccess & 8) == 0) {
                    int lengthBackup = sb.length();
                    index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index, false);
                    sb.setLength(lengthBackup);
                }
                if (descriptor.charAt(index) != ')') {
                    int varargsParameterIndex;
                    if ((methodAccess & 0x80) == 0) {
                        varargsParameterIndex = Integer.MAX_VALUE;
                    } else {
                        int indexBackup = index;
                        int lengthBackup = sb.length();
                        varargsParameterIndex = -1;
                        while (descriptor.charAt(index) != ')') {
                            index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index, false);
                            ++varargsParameterIndex;
                        }
                        index = indexBackup;
                        sb.setLength(lengthBackup);
                    }
                    index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index, false);
                    int parameterIndex = 1;
                    while (descriptor.charAt(index) != ')') {
                        sb.append(", ");
                        index = AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, index, parameterIndex == varargsParameterIndex);
                        ++parameterIndex;
                    }
                }
            }
            if (isAConstructor) {
                sb.append(')');
            } else {
                sb.append(") : ");
                AbstractTypeFactoryProvider.writeSignature(sb, descriptor, length, ++index, false);
            }
        }
    }

    protected static ImageIcon getTypeIcon(int access) {
        if ((access & 0x2000) != 0) {
            return ANNOTATION_ICON;
        }
        if ((access & 0x200) != 0) {
            return INTERFACE_ICONS[AbstractTypeFactoryProvider.accessToIndex(access)];
        }
        if ((access & 0x4000) != 0) {
            return ENUM_ICON;
        }
        return CLASS_ICONS[AbstractTypeFactoryProvider.accessToIndex(access)];
    }

    protected static ImageIcon getFieldIcon(int access) {
        return FIELD_ICONS[AbstractTypeFactoryProvider.accessToIndex(access)];
    }

    protected static ImageIcon getMethodIcon(int access) {
        return METHOD_ICONS[AbstractTypeFactoryProvider.accessToIndex(access)];
    }

    protected static int accessToIndex(int access) {
        int index = 0;
        if ((access & 8) != 0) {
            index += 4;
        }
        if ((access & 0x10) != 0) {
            index += 8;
        }
        if ((access & 0x400) != 0) {
            index += 16;
        }
        if ((access & 1) != 0) {
            return index + 1;
        }
        if ((access & 4) != 0) {
            return index + 2;
        }
        if ((access & 2) != 0) {
            return index + 3;
        }
        return index;
    }

    protected static ImageIcon mergeIcons(ImageIcon background, ImageIcon overlay, int x, int y) {
        int w = background.getIconWidth();
        int h = background.getIconHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        if (x + overlay.getIconWidth() > w) {
            x = w - overlay.getIconWidth();
        }
        if (y + overlay.getIconHeight() > h) {
            y = h - overlay.getIconHeight();
        }
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(background.getImage(), 0, 0, null);
        g2.drawImage(overlay.getImage(), x, y, null);
        g2.dispose();
        return new ImageIcon(image);
    }

    protected static ImageIcon[] mergeIcons(ImageIcon[] backgrounds, ImageIcon overlay, int x, int y) {
        int length = backgrounds.length;
        ImageIcon[] result = new ImageIcon[length * 2];
        System.arraycopy(backgrounds, 0, result, 0, length);
        for (int i = 0; i < length; ++i) {
            result[length + i] = AbstractTypeFactoryProvider.mergeIcons(backgrounds[i], overlay, x, y);
        }
        return result;
    }

    protected static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        public static final int CACHE_MAX_ENTRIES = 100;

        public Cache() {
            super(150, 0.7f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 100;
        }
    }
}

