/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.Jin;
import free.jin.Session;
import free.jin.SessionEvent;
import free.jin.SessionListener;
import free.jin.plugin.Plugin;
import free.jin.ui.OptionPanel;
import free.jin.ui.PreferencesPanel;
import free.jin.ui.UiPrefsPanel;
import free.util.AWTUtilities;
import free.util.PlatformUtils;
import free.util.WindowDisposingListener;
import free.util.models.BooleanModel;
import free.util.models.Model;
import free.util.models.ModelUtils;
import free.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PrefsMenu
extends JMenu
implements SessionListener {
    private final JMenuItem lnfMenu;
    private boolean isConnected = false;
    private int separatorIndex = -1;
    private Plugin[] plugins = null;

    public PrefsMenu() {
        I18n i18n = I18n.get(PrefsMenu.class);
        i18n.initAbstractButton(this, "this");
        this.lnfMenu = i18n.createMenuItem("userInterfaceMenuItem");
        this.add(this.lnfMenu);
        this.lnfMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Frame frame = AWTUtilities.frameForComponent(PrefsMenu.this);
                PrefsDialog prefsDialog = new PrefsDialog(frame, I18n.get(class$free$jin$ui$PrefsMenu == null ? (class$free$jin$ui$PrefsMenu = PrefsMenu.class$("free.jin.ui.PrefsMenu")) : class$free$jin$ui$PrefsMenu).getString("userInterfacePrefsDialog.title"), new UiPrefsPanel());
                AWTUtilities.centerWindow(prefsDialog, frame);
                prefsDialog.setVisible(true);
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        Jin.getInstance().getConnManager().addSessionListener(this);
        Session session = Jin.getInstance().getConnManager().getSession();
        this.setConnected(session != null, session);
    }

    public void removeNotify() {
        super.removeNotify();
        Jin.getInstance().getConnManager().removeSessionListener(this);
    }

    public void sessionEstablished(SessionEvent sessionEvent) {
        this.setConnected(true, sessionEvent.getSession());
    }

    public void sessionClosed(SessionEvent sessionEvent) {
        this.setConnected(false, sessionEvent.getSession());
    }

    public void setConnected(boolean bl, Session session) {
        if (this.isConnected == bl) {
            return;
        }
        this.isConnected = bl;
        this.plugins = session.getPlugins();
        if (bl) {
            this.addPluginPreferenceMenuItems();
        } else {
            this.removePluginPreferenceMenuItems();
        }
    }

    private void addPluginPreferenceMenuItems() {
        Object object;
        Plugin plugin;
        int n;
        this.separatorIndex = this.getItemCount();
        this.addSeparator();
        for (n = 0; n < this.plugins.length; ++n) {
            plugin = this.plugins[n];
            if (!plugin.hasPreferencesUI()) continue;
            object = new JMenuItem(this.plugins[n].getName() + "...");
            ((AbstractButton)object).setActionCommand(String.valueOf(n));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    Plugin plugin = PrefsMenu.this.plugins[n];
                    I18n i18n = I18n.get(class$free$jin$ui$PrefsMenu == null ? (class$free$jin$ui$PrefsMenu = PrefsMenu.class$("free.jin.ui.PrefsMenu")) : class$free$jin$ui$PrefsMenu);
                    String string = i18n.getFormattedString("pluginPrefsDialog.title", new Object[]{plugin.getName()});
                    Frame frame = AWTUtilities.frameForComponent(PrefsMenu.this);
                    PrefsDialog prefsDialog = new PrefsDialog(frame, string, plugin.getPreferencesUI());
                    AWTUtilities.centerWindow(prefsDialog, frame);
                    prefsDialog.setVisible(true);
                }
            });
            this.add((JMenuItem)object);
        }
        this.addSeparator();
        for (n = 0; n < this.plugins.length; ++n) {
            plugin = this.plugins[n];
            object = plugin.getHotPrefs();
            if (object == null) continue;
            for (int i = 0; i < ((Model[])object).length; ++i) {
                Object object2 = object[i];
                if (!(object2 instanceof BooleanModel)) {
                    throw new IllegalArgumentException("Unsupported model: " + object2);
                }
                this.addBooleanPref((BooleanModel)object2);
            }
        }
    }

    private void addBooleanPref(BooleanModel booleanModel) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(booleanModel.getName(), booleanModel.get());
        ModelUtils.link(booleanModel, jCheckBoxMenuItem.getModel());
        this.add(jCheckBoxMenuItem);
    }

    private void removePluginPreferenceMenuItems() {
        while (this.separatorIndex < this.getItemCount()) {
            this.remove(this.separatorIndex);
        }
        this.separatorIndex = -1;
    }

    private class PrefsDialog
    extends JDialog
    implements ChangeListener,
    ActionListener {
        private final PreferencesPanel prefsPanel;
        private final JButton okButton;
        private final JButton applyButton;
        private final JButton cancelButton;

        public PrefsDialog(Frame frame, String string, PreferencesPanel preferencesPanel) {
            super(frame, string, true);
            I18n i18n = I18n.get(class$free$jin$ui$PrefsMenu == null ? (class$free$jin$ui$PrefsMenu = PrefsMenu.class$("free.jin.ui.PrefsMenu")) : class$free$jin$ui$PrefsMenu);
            this.prefsPanel = preferencesPanel;
            this.applyButton = i18n.createButton("prefsDialog.applyButton");
            this.okButton = i18n.createButton("prefsDialog.okButton");
            this.cancelButton = i18n.createButton("prefsDialog.cancelButton");
            this.createUI();
            this.setDefaultCloseOperation(2);
            SwingUtils.registerEscapeCloser(this);
            this.okButton.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.cancelButton.addActionListener(new WindowDisposingListener(this));
            preferencesPanel.addChangeListener(this);
        }

        private void createUI() {
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            jPanel.add((Component)this.prefsPanel, "Center");
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)new JSeparator(0), "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            this.applyButton.setEnabled(false);
            jPanel3.add(this.okButton);
            jPanel3.add(this.cancelButton);
            jPanel3.add(this.applyButton);
            jPanel2.add((Component)jPanel3, "South");
            if (PlatformUtils.isMacOSX()) {
                jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
            }
            container.add((Component)jPanel2, "South");
            this.getRootPane().setDefaultButton(this.okButton);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.applyButton.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                try {
                    if (this.applyButton.isEnabled()) {
                        this.prefsPanel.applyChanges();
                    }
                    this.applyButton.setEnabled(false);
                    if (actionEvent.getSource() == this.okButton) {
                        this.dispose();
                    }
                }
                catch (BadChangesException badChangesException) {
                    OptionPanel.error(I18n.get(class$free$jin$ui$PrefsMenu == null ? (class$free$jin$ui$PrefsMenu = PrefsMenu.class$("free.jin.ui.PrefsMenu")) : class$free$jin$ui$PrefsMenu).getString("badPrefsChangeDialog.title"), badChangesException.getMessage(), this);
                    if (badChangesException.getErrorComponent() == null) break block4;
                    badChangesException.getErrorComponent().requestFocus();
                }
            }
        }
    }
}

