/*
 * Decompiled with CFR 0.152.
 */
package free.jin.gamelogger;

import bsh.EvalError;
import bsh.Interpreter;
import free.chess.Chess;
import free.chess.ChessMove;
import free.chess.Move;
import free.chess.Player;
import free.chess.Position;
import free.jin.Connection;
import free.jin.Game;
import free.jin.PGNConnection;
import free.jin.Preferences;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.GameEndEvent;
import free.jin.event.GameListener;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.ListenerManager;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PositionChangedEvent;
import free.jin.event.TakebackEvent;
import free.jin.gamelogger.GameLoggerPreferencesPanel;
import free.jin.gamelogger.LoggingRule;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginContext;
import free.jin.ui.OptionPanel;
import free.jin.ui.PreferencesPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class GameLogger
extends Plugin
implements GameListener,
PropertyChangeListener {
    public static final int LOG_NONE = 0;
    public static final int LOG_ALL = 1;
    public static final int USE_RULES = 2;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private final Hashtable gamesToGameInfo = new Hashtable();
    private int loggingMode;
    private String allGamesLogFile;
    private Vector loggingRules;

    public boolean setContext(PluginContext pluginContext) {
        if (!(pluginContext.getConnection() instanceof PGNConnection)) {
            return false;
        }
        return super.setContext(pluginContext);
    }

    public int getLoggingMode() {
        return this.loggingMode;
    }

    public String getLogFileForAll() {
        return this.allGamesLogFile;
    }

    public Vector getLoggingRules() {
        Vector<LoggingRule> vector = new Vector<LoggingRule>(this.loggingRules.size());
        for (int i = 0; i < this.loggingRules.size(); ++i) {
            LoggingRule loggingRule = (LoggingRule)this.loggingRules.elementAt(i);
            vector.addElement(new LoggingRule(loggingRule));
        }
        return vector;
    }

    public void start() {
        this.registerListeners();
        this.loadLoggingConditions();
    }

    public void stop() {
        this.unregisterListeners();
    }

    protected void registerListeners() {
        Connection connection = this.getConn();
        ListenerManager listenerManager = connection.getListenerManager();
        listenerManager.addGameListener((GameListener)this);
    }

    protected void unregisterListeners() {
        Connection connection = this.getConn();
        ListenerManager listenerManager = connection.getListenerManager();
        listenerManager.removeGameListener((GameListener)this);
    }

    private void loadLoggingConditions() {
        Preferences preferences = this.getPrefs();
        String string = preferences.getString("logging.mode", "none");
        this.loggingMode = "rules".equalsIgnoreCase(string) ? 2 : ("all".equalsIgnoreCase(string) ? 1 : 0);
        this.allGamesLogFile = preferences.getString("logging.all.filename", null);
        if (this.allGamesLogFile == null && this.loggingMode == 1) {
            this.loggingMode = 0;
        }
        int n = preferences.getInt("logging.rules.count", 0);
        this.loggingRules = new Vector(n);
        for (int i = 0; i < n; ++i) {
            String string2 = preferences.getString("logging.rule-" + (i + 1) + ".name");
            String string3 = preferences.getString("logging.rule-" + (i + 1) + ".condition");
            String string4 = preferences.getString("logging.rule-" + (i + 1) + ".filename");
            try {
                this.loggingRules.addElement(new LoggingRule(string2, string3, string4));
                continue;
            }
            catch (EvalError evalError) {
                evalError.printStackTrace();
            }
        }
    }

    public void refreshFromProperties() {
        this.loadLoggingConditions();
    }

    static String[][] getAvailableVars() {
        return new String[][]{{"category", "\"Blitz\""}, {"rating", "1800"}, {"time", "10"}, {"inc", "2"}, {"etime", "2.5"}, {"rated", "true"}, {"opponent", "\"AlexTheGreat\""}, {"title", "\"gm\""}, {"moves", "40"}, {"userWhite", "true"}, {"userBlack", "false"}, {"result", "\"win\""}, {"win", "true"}, {"loss", "false"}, {"draw", "false"}, {"unknownResult", "false"}, {"whiteWins", "true"}, {"blackWins", "true"}};
    }

    private String[] getFilesToLogInto(Game game) {
        Object object;
        if (this.loggingMode == 0) {
            return null;
        }
        if (this.loggingMode == 1) {
            return new String[]{this.allGamesLogFile};
        }
        GameInfo gameInfo = (GameInfo)this.gamesToGameInfo.get(game);
        Interpreter interpreter = new Interpreter();
        boolean bl = game.getUserPlayer().isWhite();
        try {
            interpreter.set("category", (Object)game.getRatingCategoryString());
            interpreter.set("rating", bl ? game.getBlackRating() : game.getWhiteRating());
            interpreter.set("time", (bl ? game.getWhiteTime() : game.getBlackTime()) / 60000);
            interpreter.set("inc", bl ? game.getWhiteInc() : game.getBlackInc());
            interpreter.set("etime", bl ? game.getWhiteTime() + 2 * game.getWhiteInc() / 3 : game.getBlackTime() + 2 * game.getBlackInc() / 3);
            interpreter.set("rated", game.isRated());
            interpreter.set("opponent", (Object)(bl ? game.getBlackName() : game.getWhiteName()));
            interpreter.set("title", (Object)(bl ? game.getBlackTitles() : game.getWhiteTitles()));
            interpreter.set("moves", gameInfo.movelist.size());
            interpreter.set("userWhite", game.getUserPlayer() == Player.WHITE_PLAYER);
            interpreter.set("userBlack", game.getUserPlayer() == Player.BLACK_PLAYER);
            object = GameLogger.getResultString(bl, game.getResult());
            interpreter.set("result", object);
            interpreter.set("win", ((String)object).equals("win"));
            interpreter.set("loss", ((String)object).equals("loss"));
            interpreter.set("draw", ((String)object).equals("draw"));
            interpreter.set("unknownResult", ((String)object).equals("unknownResult"));
            interpreter.set("whiteWins", game.getResult() == 1);
            interpreter.set("blackWins", game.getResult() == 2);
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
            return new String[0];
        }
        object = new Vector();
        for (int i = 0; i < this.loggingRules.size(); ++i) {
            LoggingRule loggingRule = (LoggingRule)this.loggingRules.elementAt(i);
            String string = loggingRule.getCondition();
            try {
                boolean bl2 = (Boolean)interpreter.eval(string);
                if (!bl2) continue;
                ((Vector)object).addElement(loggingRule.getFilename());
                continue;
            }
            catch (EvalError evalError) {
                evalError.printStackTrace();
            }
        }
        if (((Vector)object).size() == 0) {
            return null;
        }
        String[] stringArray = new String[((Vector)object).size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)((Vector)object).elementAt(i);
        }
        return stringArray;
    }

    private static final String getResultString(boolean bl, int n) {
        switch (n) {
            case 4: {
                return "unknown";
            }
            case 3: {
                return "draw";
            }
            case 1: {
                if (bl) {
                    return "win";
                }
                return "loss";
            }
            case 2: {
                if (bl) {
                    return "loss";
                }
                return "win";
            }
        }
        throw new IllegalArgumentException("Bad result value: " + n);
    }

    protected boolean canLog(Game game) {
        return game.getGameType() == 1 && game.getVariant() instanceof Chess;
    }

    private void log(Game game) {
        String[] stringArray = this.getFilesToLogInto(game);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.log(game, stringArray[i]);
            }
        }
    }

    private void log(Game game, String string) {
        GameInfo gameInfo = (GameInfo)this.gamesToGameInfo.get(game);
        try {
            String string2;
            switch (game.getResult()) {
                case 1: {
                    string2 = "1-0";
                    break;
                }
                case 2: {
                    string2 = "0-1";
                    break;
                }
                case 3: {
                    string2 = "1/2-1/2";
                    break;
                }
                default: {
                    string2 = "*";
                }
            }
            int n = game.getWhiteRating();
            int n2 = game.getBlackRating();
            String string3 = n < 0 ? "-" : String.valueOf(n);
            String string4 = n2 < 0 ? "-" : String.valueOf(n2);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string, true)));
            GameLogger.writeTag(dataOutputStream, "Event", (game.isRated() ? "rated " : "unrated ") + game.getRatingCategoryString() + " game");
            GameLogger.writeTag(dataOutputStream, "Site", this.getUser().getServer().getLongName());
            GameLogger.writeTag(dataOutputStream, "Date", DATE_FORMAT.format(gameInfo.gameStartDate));
            GameLogger.writeTag(dataOutputStream, "Round", "-");
            GameLogger.writeTag(dataOutputStream, "White", game.getWhiteName());
            GameLogger.writeTag(dataOutputStream, "Black", game.getBlackName());
            GameLogger.writeTag(dataOutputStream, "WhiteElo", string3);
            GameLogger.writeTag(dataOutputStream, "BlackElo", string4);
            GameLogger.writeTag(dataOutputStream, "Result", string2);
            GameLogger.writeTag(dataOutputStream, "Time", TIME_FORMAT.format(gameInfo.gameStartDate));
            if (!game.isTimeOdds()) {
                GameLogger.writeTag(dataOutputStream, "TimeControl", game.getWhiteTime() / 1000 + "+" + game.getWhiteInc());
            }
            GameLogger.writeTag(dataOutputStream, "Mode", "ICS");
            if (!gameInfo.initPos.getFEN().equals("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1")) {
                GameLogger.writeTag(dataOutputStream, "SetUp", "1");
                GameLogger.writeTag(dataOutputStream, "FEN", gameInfo.initPos.getFEN());
            }
            dataOutputStream.writeBytes("\n");
            Vector vector = gameInfo.movelist;
            int n3 = vector.size();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < n3; ++i) {
                stringBuffer2.setLength(0);
                ChessMove chessMove = (ChessMove)vector.elementAt(i);
                Player player = chessMove.getPlayer();
                String string5 = chessMove.getSAN();
                if (i == 0 && player.isBlack()) {
                    stringBuffer2.append("1... ");
                    stringBuffer2.append(string5);
                } else {
                    if (player.isWhite()) {
                        stringBuffer2.append(String.valueOf(1 + i / 2));
                        stringBuffer2.append(". ");
                    }
                    stringBuffer2.append(string5);
                }
                if (stringBuffer.length() + 1 + stringBuffer2.length() > 80) {
                    dataOutputStream.writeBytes(stringBuffer.toString());
                    dataOutputStream.writeBytes("\n");
                    stringBuffer.setLength(0);
                    stringBuffer.append(stringBuffer2.toString());
                } else {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(stringBuffer2.toString());
                }
                stringBuffer2.setLength(0);
            }
            if (stringBuffer.length() + 1 + string2.length() > 80) {
                dataOutputStream.writeBytes(stringBuffer.toString());
                dataOutputStream.writeBytes("\n");
                dataOutputStream.writeBytes(string2);
            } else {
                dataOutputStream.writeBytes(stringBuffer.toString());
                dataOutputStream.writeBytes(" ");
                dataOutputStream.writeBytes(string2);
            }
            dataOutputStream.writeBytes("\n\n");
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            OptionPanel.error((String)"I/O Error", (String)("Unable to log game:\n" + iOException.getMessage()));
        }
    }

    private static void writeTag(DataOutputStream dataOutputStream, String string, String string2) throws IOException {
        dataOutputStream.writeBytes("[" + string + " \"" + string2 + "\"]\n");
    }

    public void gameStarted(GameStartEvent gameStartEvent) {
        Game game = gameStartEvent.getGame();
        Position position = game.getInitialPosition();
        GameInfo gameInfo = new GameInfo(position);
        this.gamesToGameInfo.put(game, gameInfo);
        game.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void gameEnded(GameEndEvent gameEndEvent) {
        Game game = gameEndEvent.getGame();
        if (this.canLog(game) && game.isPlayed()) {
            this.log(game);
        }
        this.gamesToGameInfo.remove(game);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Game game = (Game)propertyChangeEvent.getSource();
        if (this.canLog(game) && propertyChangeEvent.getPropertyName().equals("played") && !game.isPlayed()) {
            this.log(game);
        }
    }

    public void moveMade(MoveMadeEvent moveMadeEvent) {
        Game game = moveMadeEvent.getGame();
        Move move = moveMadeEvent.getMove();
        GameInfo gameInfo = (GameInfo)this.gamesToGameInfo.get(game);
        gameInfo.movelist.addElement(move);
    }

    public void positionChanged(PositionChangedEvent positionChangedEvent) {
        Game game = positionChangedEvent.getGame();
        GameInfo gameInfo = (GameInfo)this.gamesToGameInfo.get(game);
        gameInfo.initPos = positionChangedEvent.getPosition();
    }

    public void takebackOccurred(TakebackEvent takebackEvent) {
        Game game = takebackEvent.getGame();
        GameInfo gameInfo = (GameInfo)this.gamesToGameInfo.get(game);
        Vector vector = gameInfo.movelist;
        int n = vector.size() - 1;
        int n2 = Math.max(0, vector.size() - takebackEvent.getTakebackCount());
        for (int i = n; i >= n2; --i) {
            vector.removeElementAt(i);
        }
    }

    public void illegalMoveAttempted(IllegalMoveEvent illegalMoveEvent) {
    }

    public void clockAdjusted(ClockAdjustmentEvent clockAdjustmentEvent) {
    }

    public void boardFlipped(BoardFlipEvent boardFlipEvent) {
    }

    public void offerUpdated(OfferEvent offerEvent) {
    }

    public PreferencesPanel getPreferencesUI() {
        return new GameLoggerPreferencesPanel(this);
    }

    public boolean hasPreferencesUI() {
        return true;
    }

    public String getId() {
        return "gamelogger";
    }

    public String getName() {
        return this.getI18n().getString("pluginName");
    }

    private static class GameInfo {
        public Position initPos;
        public Vector movelist;
        public final Date gameStartDate;

        public GameInfo(Position position) {
            this.initPos = position;
            this.movelist = new Vector();
            this.gameStartDate = new Date();
        }
    }
}

