/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Trace;
import org.hsqldb.persist.ScaledRAFile;

class NIOScaledRAFile
extends ScaledRAFile {
    MappedByteBuffer buffer;
    FileChannel channel;
    long bufferLength;
    private boolean wasNio;
    private boolean bufferModified;
    static final long MAX_NIO_LENGTH = 0x10000000L;

    public NIOScaledRAFile(String string, boolean bl) throws FileNotFoundException, IOException {
        super(string, bl);
        if (super.length() > 0x10000000L) {
            Trace.printSystemOut("Initiatiated without nio");
            return;
        }
        this.isNio = true;
        this.wasNio = true;
        this.channel = this.file.getChannel();
        this.enlargeBuffer(super.length(), 0);
        Trace.printSystemOut("initial length " + super.length());
        Trace.printSystemOut("NIO file instance created. mode:  " + bl);
    }

    private long newBufferSize(long l) throws IOException {
        long l2;
        int n = 20;
        while ((l2 = 1L << n) < l) {
            ++n;
        }
        return l2;
    }

    private void enlargeBuffer(long l, int n) throws IOException {
        int n2 = 0;
        if (this.buffer != null) {
            n2 = this.buffer.position();
            try {
                if (this.bufferModified) {
                    this.buffer.force();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception.getMessage());
            }
        }
        long l2 = this.newBufferSize(l + (long)n);
        Trace.printSystemOut("NIO next enlargeBuffer():  " + l2);
        if (this.bufferLength > 0x1000000L) {
            System.gc();
        }
        if (this.bufferLength <= 0x10000000L) {
            try {
                this.buffer = this.channel.map(this.isReadOnly() ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, l2);
                this.bufferModified = false;
            }
            catch (Exception exception) {
                Trace.printSystemOut("NIO enlargeBuffer() failed:  " + l2);
                this.isNio = false;
                this.buffer = null;
                this.channel = null;
                System.gc();
                super.seek(n2);
                return;
            }
        } else {
            Trace.printSystemOut("Stopped NIO at enlargeBuffer():  " + l2);
            this.isNio = false;
            this.buffer = null;
            this.channel = null;
            System.gc();
            super.seek(n2);
            return;
        }
        this.bufferLength = l2;
        this.buffer.position(n2);
    }

    public void seek(long l) throws IOException {
        if (!this.isNio) {
            super.seek(l);
            return;
        }
        if (l == this.bufferLength) {
            Trace.printSystemOut("Seek to buffer length " + l);
        }
        if (l > this.bufferLength) {
            this.enlargeBuffer(l, 4);
            if (!this.isNio) {
                super.seek(l);
                return;
            }
        }
        this.buffer.position((int)l);
    }

    public long getFilePointer() throws IOException {
        if (!this.isNio) {
            return super.getFilePointer();
        }
        return this.buffer.position();
    }

    public int read() throws IOException {
        if (!this.isNio) {
            return super.read();
        }
        return this.buffer.get();
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isNio) {
            super.read(byArray, n, n2);
            return;
        }
        this.buffer.get(byArray, n, n2);
    }

    public int readInt() throws IOException {
        if (!this.isNio) {
            return super.readInt();
        }
        return this.buffer.getInt();
    }

    public long readLong() throws IOException {
        if (!this.isNio) {
            return super.readLong();
        }
        return this.buffer.getLong();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isNio) {
            super.write(byArray, n, n2);
            return;
        }
        this.bufferModified = true;
        if ((long)this.buffer.position() + (long)n2 > this.bufferLength) {
            this.enlargeBuffer(this.buffer.position(), n2);
            if (!this.isNio) {
                super.write(byArray, n, n2);
                return;
            }
        }
        this.buffer.put(byArray, n, n2);
    }

    public void writeInt(int n) throws IOException {
        if (!this.isNio) {
            super.writeInt(n);
            return;
        }
        this.bufferModified = true;
        if ((long)this.buffer.position() + 4L > this.bufferLength) {
            this.enlargeBuffer(this.buffer.position(), 4);
            if (!this.isNio) {
                super.writeInt(n);
                return;
            }
        }
        this.buffer.putInt(n);
    }

    public void writeLong(long l) throws IOException {
        if (!this.isNio) {
            super.writeLong(l);
            return;
        }
        this.bufferModified = true;
        if ((long)this.buffer.position() + 4L > this.bufferLength) {
            this.enlargeBuffer(this.buffer.position(), 4);
            if (!this.isNio) {
                super.writeLong(l);
                return;
            }
        }
        this.buffer.putLong(l);
    }

    public void close() throws IOException {
        if (!this.isNio) {
            super.close();
            return;
        }
        Trace.printSystemOut("NIO next close() - fileLength = " + this.bufferLength);
        Trace.printSystemOut("NIO next buffer.force()");
        if (this.buffer != null && this.bufferModified) {
            this.buffer.force();
        }
        this.buffer = null;
        this.channel = null;
        Trace.printSystemOut("NIO next file.close()");
        this.file.close();
        System.gc();
    }

    public boolean wasNio() {
        return this.wasNio;
    }
}

