/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.spider;

import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.common.AbstractParam;

public class SpiderParam
extends AbstractParam {
    private static final String SPIDER = "spider";
    private static final String SPIDER_MAX_DEPTH = "spider.maxDepth";
    private static final String SPIDER_THREAD = "spider.thread";
    private static final String SPIDER_SCOPE = "spider.scope";
    private static final String SPIDER_POST_FORM = "spider.postform";
    private static final String SPIDER_SKIP_URL = "spider.skipurl";
    private int maxDepth = 5;
    private int thread = 2;
    private String scope = "";
    private int postForm = 0;
    private String skipURL = "";
    private Pattern patternSkipURL = null;
    private Pattern patternScope = null;

    protected void parse() {
        try {
            this.setThread(this.getConfig().getInt(SPIDER_THREAD, 2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setMaxDepth(this.getConfig().getInt(SPIDER_MAX_DEPTH, 5));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setPostForm(this.getConfig().getInt(SPIDER_POST_FORM, 0) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setScope(this.getConfig().getString(SPIDER_SCOPE, ""));
        this.setSkipURL(this.getConfig().getString(SPIDER_SKIP_URL, ""));
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
        this.getConfig().setProperty(SPIDER_MAX_DEPTH, Integer.toString(this.maxDepth));
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
        this.getConfig().setProperty(SPIDER_SCOPE, this.scope);
        this.parseScope(this.scope);
    }

    public int getThread() {
        return this.thread;
    }

    public void setThread(int n) {
        this.thread = n;
        this.getConfig().setProperty(SPIDER_THREAD, Integer.toString(this.thread));
    }

    public boolean isInScope(String string) {
        if (this.patternScope == null || string == null) {
            return false;
        }
        return this.patternScope.matcher(string).find();
    }

    private void parseScope(String string) {
        this.patternScope = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(;+$)|(^;+)", "");
        string = "(" + string.replaceAll(";+", "|") + ")$";
        this.patternScope = Pattern.compile(string, 2);
    }

    public boolean isPostForm() {
        return this.postForm != 0;
    }

    public void setPostForm(boolean bl) {
        this.postForm = bl ? 1 : 0;
        this.getConfig().setProperty(SPIDER_POST_FORM, Integer.toString(this.postForm));
    }

    public void setSkipURL(String string) {
        this.skipURL = string;
        this.getConfig().setProperty(SPIDER_SKIP_URL, this.skipURL);
        this.parseSkipURL(this.skipURL);
    }

    public boolean isSkipURL(URI uRI) {
        if (this.patternSkipURL == null || uRI == null) {
            return false;
        }
        String string = uRI.toString();
        return this.patternSkipURL.matcher(string).find();
    }

    private void parseSkipURL(String string) {
        this.patternSkipURL = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(\\s+$)|(^\\s+)", "");
        string = "\\A(" + string.replaceAll("\\s+", "|") + ")";
        this.patternSkipURL = Pattern.compile(string, 10);
    }

    public String getSkipURL() {
        return this.skipURL;
    }
}

