/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.db.AbstractTable;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class TableHistory
extends AbstractTable {
    private static final String HISTORYID = "HISTORYID";
    private static final String SESSIONID = "SESSIONID";
    private static final String HISTTYPE = "HISTTYPE";
    private static final String METHOD = "METHOD";
    private static final String URI = "URI";
    private static final String STATUSCODE = "STATUSCODE";
    private static final String TIMESENTMILLIS = "TIMESENTMILLIS";
    private static final String TIMEELAPSEDMILLIS = "TIMEELAPSEDMILLIS";
    private static final String REQHEADER = "REQHEADER";
    private static final String REQBODY = "REQBODY";
    private static final String RESHEADER = "RESHEADER";
    private static final String RESBODY = "RESBODY";
    private static final String TAG = "TAG";
    private PreparedStatement psRead = null;
    private PreparedStatement psWrite1 = null;
    private CallableStatement psWrite2 = null;
    private PreparedStatement psDelete = null;
    private PreparedStatement psDeleteTemp = null;
    private PreparedStatement psContainsURI = null;
    private PreparedStatement psAlterTable = null;
    private PreparedStatement psUpdateTag = null;
    private static boolean isExistStatusCode = false;

    protected void reconnect(Connection connection) throws SQLException {
        this.psRead = connection.prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE HISTORYID = ?");
        this.psDelete = connection.prepareStatement("DELETE FROM HISTORY WHERE HISTORYID = ?");
        this.psDeleteTemp = connection.prepareStatement("DELETE FROM HISTORY WHERE HISTTYPE = 0");
        this.psContainsURI = connection.prepareStatement("SELECT TOP 1 HISTORYID FROM HISTORY WHERE URI = ? AND  METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND HISTTYPE = ?");
        isExistStatusCode = false;
        ResultSet resultSet = connection.getMetaData().getColumns(null, null, "HISTORY", STATUSCODE);
        if (resultSet.next()) {
            isExistStatusCode = true;
        }
        resultSet.close();
        this.psWrite1 = isExistStatusCode ? connection.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,TIMESENTMILLIS,TIMEELAPSEDMILLIS,METHOD,URI,REQHEADER,REQBODY,RESHEADER,RESBODY,STATUSCODE) VALUES (?, ? ,?, ?, ?, ?, ?, ? ,? , ?, ?)") : connection.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,TIMESENTMILLIS,TIMEELAPSEDMILLIS,METHOD,URI,REQHEADER,REQBODY,RESHEADER,RESBODY) VALUES (?, ? ,?, ?, ?, ?, ?, ? ,? , ?)");
        this.psWrite2 = connection.prepareCall("CALL IDENTITY();");
        resultSet = connection.getMetaData().getColumns(null, null, "HISTORY", TAG);
        if (!resultSet.next()) {
            PreparedStatement preparedStatement = connection.prepareStatement("ALTER TABLE HISTORY ADD COLUMN TAG VARCHAR DEFAULT ''");
            preparedStatement.execute();
        }
        resultSet.close();
        this.psUpdateTag = connection.prepareStatement("UPDATE HISTORY SET TAG = ? WHERE HISTORYID = ?");
    }

    public synchronized RecordHistory read(int n) throws HttpMalformedHeaderException, SQLException {
        this.psRead.setInt(1, n);
        this.psRead.execute();
        ResultSet resultSet = this.psRead.getResultSet();
        RecordHistory recordHistory = this.build(resultSet);
        resultSet.close();
        return recordHistory;
    }

    public synchronized RecordHistory write(long l, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, SQLException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n2 = 0;
        if (!httpMessage.getRequestHeader().isEmpty()) {
            string = httpMessage.getRequestHeader().toString();
            string2 = httpMessage.getRequestBody().toString("8859_1");
            string5 = httpMessage.getRequestHeader().getMethod();
            string6 = httpMessage.getRequestHeader().getURI().toString();
        }
        if (!httpMessage.getResponseHeader().isEmpty()) {
            string3 = httpMessage.getResponseHeader().toString();
            string4 = httpMessage.getResponseBody().toString("8859_1");
            n2 = httpMessage.getResponseHeader().getStatusCode();
        }
        return this.write(l, n, httpMessage.getTimeSentMillis(), httpMessage.getTimeElapsedMillis(), string5, string6, n2, string, string2, string3, string4);
    }

    private synchronized RecordHistory write(long l, int n, long l2, int n2, String string, String string2, int n3, String string3, String string4, String string5, String string6) throws HttpMalformedHeaderException, SQLException {
        this.psWrite1.setLong(1, l);
        this.psWrite1.setInt(2, n);
        this.psWrite1.setLong(3, l2);
        this.psWrite1.setInt(4, n2);
        this.psWrite1.setString(5, string);
        this.psWrite1.setString(6, string2);
        this.psWrite1.setString(7, string3);
        this.psWrite1.setString(8, string4);
        this.psWrite1.setString(9, string5);
        this.psWrite1.setString(10, string6);
        if (isExistStatusCode) {
            this.psWrite1.setInt(11, n3);
        }
        this.psWrite1.executeUpdate();
        this.psWrite2.executeQuery();
        ResultSet resultSet = this.psWrite2.getResultSet();
        resultSet.next();
        int n4 = resultSet.getInt(1);
        resultSet.close();
        return this.read(n4);
    }

    private RecordHistory build(ResultSet resultSet) throws HttpMalformedHeaderException, SQLException {
        RecordHistory recordHistory = null;
        if (resultSet.next()) {
            recordHistory = new RecordHistory(resultSet.getInt(HISTORYID), resultSet.getInt(HISTTYPE), resultSet.getLong(SESSIONID), resultSet.getLong(TIMESENTMILLIS), resultSet.getInt(TIMEELAPSEDMILLIS), resultSet.getString(REQHEADER), resultSet.getString(REQBODY), resultSet.getString(RESHEADER), resultSet.getString(RESBODY), resultSet.getString(TAG));
        }
        return recordHistory;
    }

    public Vector getHistoryList(long l, int n) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT HISTORYID FROM HISTORY WHERE SESSIONID = ? AND HISTTYPE = ? ORDER BY HISTORYID");
        Vector<Integer> vector = new Vector<Integer>();
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        preparedStatement.executeQuery();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(HISTORYID);
            vector.add(new Integer(n2));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public List getHistoryList(long l, int n, String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE SESSIONID = ? AND HISTTYPE = ? ORDER BY HISTORYID");
        Pattern pattern = Pattern.compile(string, 10);
        Matcher matcher = null;
        Vector<Integer> vector = new Vector<Integer>();
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        preparedStatement.executeQuery();
        ResultSet resultSet = preparedStatement.getResultSet();
        while (resultSet.next()) {
            if (bl) {
                matcher = pattern.matcher(resultSet.getString(REQHEADER));
                if (matcher.find()) {
                    vector.add(new Integer(resultSet.getInt(HISTORYID)));
                    continue;
                }
                matcher = pattern.matcher(resultSet.getString(REQBODY));
                if (!matcher.find()) continue;
                vector.add(new Integer(resultSet.getInt(HISTORYID)));
                continue;
            }
            matcher = pattern.matcher(resultSet.getString(RESHEADER));
            if (matcher.find()) {
                vector.add(new Integer(resultSet.getInt(HISTORYID)));
                continue;
            }
            matcher = pattern.matcher(resultSet.getString(RESBODY));
            if (!matcher.find()) continue;
            vector.add(new Integer(resultSet.getInt(HISTORYID)));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public void deleteHistorySession(long l) throws SQLException {
        Statement statement = this.getConnection().createStatement();
        statement.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + l);
        statement.close();
    }

    public void deleteHistoryType(long l, int n) throws SQLException {
        Statement statement = this.getConnection().createStatement();
        statement.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + l + " AND " + HISTTYPE + " = " + n);
        statement.close();
    }

    public void delete(int n) throws SQLException {
        this.psDelete.setInt(1, n);
        this.psDelete.executeUpdate();
    }

    public void deleteTemporary() throws SQLException {
        this.psDeleteTemp.execute();
    }

    public boolean containsURI(long l, int n, String string, String string2, String string3) throws SQLException {
        this.psContainsURI.setString(1, string2);
        this.psContainsURI.setString(2, string);
        this.psContainsURI.setString(3, string3);
        this.psContainsURI.setLong(4, l);
        this.psContainsURI.setInt(5, n);
        this.psContainsURI.executeQuery();
        ResultSet resultSet = this.psContainsURI.getResultSet();
        if (resultSet.next()) {
            return true;
        }
        resultSet.close();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordHistory getHistoryCache(HistoryReference historyReference, HttpMessage httpMessage) throws SQLException, HttpMalformedHeaderException {
        PreparedStatement preparedStatement = null;
        preparedStatement = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND HISTORYID >= ? AND HISTORYID <= ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND HISTORYID >= ? AND HISTORYID <= ? AND SESSIONID = ?)");
        preparedStatement.setString(1, httpMessage.getRequestHeader().getURI().toString());
        preparedStatement.setString(2, httpMessage.getRequestHeader().getMethod());
        preparedStatement.setString(3, httpMessage.getRequestBody().toString("8859_1"));
        preparedStatement.setInt(4, historyReference.getHistoryId());
        preparedStatement.setInt(5, historyReference.getHistoryId() + 200);
        preparedStatement.setLong(6, historyReference.getSessionId());
        preparedStatement.executeQuery();
        ResultSet resultSet = preparedStatement.getResultSet();
        RecordHistory recordHistory = null;
        try {
            do {
                if ((recordHistory = this.build(resultSet)) == null || !recordHistory.getHttpMessage().equals(httpMessage) || recordHistory.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                RecordHistory recordHistory2 = recordHistory;
                return recordHistory2;
            } while (recordHistory != null);
        }
        finally {
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        preparedStatement = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ?");
        preparedStatement.setString(1, httpMessage.getRequestHeader().getURI().toString());
        preparedStatement.setString(2, httpMessage.getRequestHeader().getMethod());
        preparedStatement.setString(3, httpMessage.getRequestBody().toString("8859_1"));
        preparedStatement.setLong(4, historyReference.getSessionId());
        preparedStatement.executeQuery();
        resultSet = preparedStatement.getResultSet();
        recordHistory = null;
        try {
            do {
                if ((recordHistory = this.build(resultSet)) == null || !recordHistory.getHttpMessage().equals(httpMessage) || recordHistory.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                RecordHistory recordHistory3 = recordHistory;
                return recordHistory3;
            } while (recordHistory != null);
        }
        finally {
            try {
                resultSet.close();
                preparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void updateTag(int n, String string) throws SQLException {
        this.psUpdateTag.setString(1, string);
        this.psUpdateTag.setInt(2, n);
        this.psUpdateTag.execute();
    }
}

