/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension;

import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;

public class ExtensionLoader {
    private Vector extensionList = new Vector();
    private Vector hookList = new Vector();
    private Model model = null;
    private View view = null;

    public ExtensionLoader(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    public void addExtension(Extension extension) {
        this.extensionList.add(extension);
    }

    public void destroyAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).destroy();
        }
    }

    public Extension getExtension(int n) {
        return (Extension)this.extensionList.get(n);
    }

    public Extension getExtension(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.extensionList.size(); ++i) {
            Extension extension = this.getExtension(i);
            if (!extension.getName().equalsIgnoreCase(string)) continue;
            return extension;
        }
        return null;
    }

    public int getExtensionCount() {
        return this.extensionList.size();
    }

    public void hookProxyListener(Proxy proxy) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            Vector vector = extensionHook.getProxyListenerList();
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    ProxyListener proxyListener = (ProxyListener)vector.get(j);
                    if (proxyListener == null) continue;
                    proxy.addProxyListener(proxyListener);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void optionsChangedAllPlugin(OptionsParam optionsParam) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            Vector vector = extensionHook.getOptionsChangedListenerList();
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    OptionsChangedListener optionsChangedListener = (OptionsChangedListener)vector.get(j);
                    if (optionsChangedListener == null) continue;
                    optionsChangedListener.OptionsChanged(optionsParam);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void runCommandLine() {
        ExtensionHook extensionHook = null;
        Extension extension = null;
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            extension = this.getExtension(i);
            extensionHook = (ExtensionHook)this.hookList.get(i);
            if (!(extension instanceof CommandLineListener)) continue;
            CommandLineListener commandLineListener = (CommandLineListener)((Object)extension);
            commandLineListener.execute(extensionHook.getCommandLineArgument());
        }
    }

    public void sessionChangedAllPlugin(Session session) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            Vector vector = extensionHook.getSessionListenerList();
            for (int j = 0; j < vector.size(); ++j) {
                try {
                    SessionChangedListener sessionChangedListener = (SessionChangedListener)vector.get(j);
                    if (sessionChangedListener == null) continue;
                    sessionChangedListener.sessionChanged(session);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void startAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).start();
        }
    }

    public void startLifeCycle() {
        this.initAllExtension();
        this.initModelAllExtension(this.model);
        this.initXMLAllExtension(this.model.getSession(), this.model.getOptionsParam());
        this.initViewAllExtension(this.view);
        this.hookAllExtension();
        this.startAllExtension();
    }

    public void stopAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).stop();
        }
    }

    private void addParamPanel(List list, AbstractParamDialog abstractParamDialog) {
        AbstractParamPanel abstractParamPanel = null;
        String[] stringArray = new String[]{};
        for (int i = 0; i < list.size(); ++i) {
            try {
                abstractParamPanel = (AbstractParamPanel)list.get(i);
                abstractParamDialog.addParamPanel(stringArray, abstractParamPanel);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addTabPanel(List list, TabbedPanel tabbedPanel) {
        AbstractPanel abstractPanel = null;
        for (int i = 0; i < list.size(); ++i) {
            try {
                abstractPanel = (AbstractPanel)list.get(i);
                tabbedPanel.add((Component)abstractPanel, abstractPanel.getName());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void hookAllExtension() {
        ExtensionHook extensionHook = null;
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            extensionHook = new ExtensionHook(this.model, this.view);
            this.getExtension(i).hook(extensionHook);
            this.hookList.add(extensionHook);
            if (this.view != null) {
                this.hookView(this.view, extensionHook);
                this.hookMenu(this.view, extensionHook);
            }
            this.hookOptions(extensionHook);
        }
        if (this.view != null) {
            this.view.getMainFrame().getMainMenuBar().validate();
            this.view.getMainFrame().validate();
        }
    }

    public void hookCommandLineListener(CommandLine commandLine) throws Exception {
        Vector<CommandLineArgument[]> vector = new Vector<CommandLineArgument[]>();
        for (int i = 0; i < this.hookList.size(); ++i) {
            ExtensionHook extensionHook = (ExtensionHook)this.hookList.get(i);
            CommandLineArgument[] commandLineArgumentArray = extensionHook.getCommandLineArgument();
            if (commandLineArgumentArray.length <= 0) continue;
            vector.add(commandLineArgumentArray);
        }
        commandLine.parse(vector);
    }

    private void hookMenu(View view, ExtensionHook extensionHook) {
        int n;
        int n2;
        if (view == null) {
            return;
        }
        if (extensionHook.getHookMenu() == null) {
            return;
        }
        ExtensionHookMenu extensionHookMenu = extensionHook.getHookMenu();
        List list = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu = null;
        JMenu jMenu2 = view.getMainFrame().getMainMenuBar().getMenuFile();
        JMenu jMenu3 = view.getMainFrame().getMainMenuBar().getMenuEdit();
        JMenu jMenu4 = view.getMainFrame().getMainMenuBar().getMenuView();
        JMenu jMenu5 = view.getMainFrame().getMainMenuBar().getMenuAnalyse();
        JMenu jMenu6 = view.getMainFrame().getMainMenuBar().getMenuTools();
        MainMenuBar mainMenuBar = view.getMainFrame().getMainMenuBar();
        list = extensionHookMenu.getNewMenus();
        for (n2 = 0; n2 < list.size(); ++n2) {
            jMenu = (JMenu)list.get(n2);
            mainMenuBar.add((Component)jMenu, mainMenuBar.getMenuCount() - 2);
        }
        list = extensionHookMenu.getFile();
        n2 = 2;
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            if (jMenuItem == ExtensionHookMenu.MENU_SEPARATOR) {
                jMenu2.addSeparator();
                continue;
            }
            jMenu2.add((Component)jMenuItem, jMenu2.getItemCount() - n2);
        }
        list = extensionHookMenu.getTools();
        n2 = 2;
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            if (jMenuItem == ExtensionHookMenu.MENU_SEPARATOR) {
                jMenu6.addSeparator();
                continue;
            }
            jMenu6.add((Component)jMenuItem, jMenu6.getItemCount() - n2);
        }
        list = extensionHookMenu.getEdit();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            if (jMenuItem == ExtensionHookMenu.MENU_SEPARATOR) {
                jMenu3.addSeparator();
                continue;
            }
            jMenu3.add((Component)jMenuItem, jMenu3.getItemCount());
        }
        list = extensionHookMenu.getView();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            if (jMenuItem == ExtensionHookMenu.MENU_SEPARATOR) {
                jMenu4.addSeparator();
                continue;
            }
            jMenu4.add((Component)jMenuItem, jMenu4.getItemCount());
        }
        list = extensionHookMenu.getAnalyse();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (JMenuItem)list.get(n);
            if (jMenuItem == null) continue;
            if (jMenuItem == ExtensionHookMenu.MENU_SEPARATOR) {
                jMenu5.addSeparator();
                continue;
            }
            jMenu5.add((Component)jMenuItem, jMenu5.getItemCount());
        }
        list = extensionHookMenu.getPopupMenus();
        for (n = 0; n < list.size(); ++n) {
            jMenuItem = (ExtensionPopupMenu)list.get(n);
            if (jMenuItem == null) continue;
            view.getPopupList().add(jMenuItem);
        }
    }

    private void hookOptions(ExtensionHook extensionHook) {
        Vector vector = extensionHook.getOptionsParamSetList();
        for (int i = 0; i < vector.size(); ++i) {
            try {
                AbstractParam abstractParam = (AbstractParam)vector.get(i);
                this.model.getOptionsParam().addParamSet(abstractParam);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void hookView(View view, ExtensionHook extensionHook) {
        if (view == null) {
            return;
        }
        ExtensionHookView extensionHookView = extensionHook.getHookView();
        if (extensionHookView == null) {
            return;
        }
        this.addTabPanel(extensionHookView.getSelectPanel(), view.getWorkbench().getTabbedSelect());
        this.addTabPanel(extensionHookView.getWorkPanel(), view.getWorkbench().getTabbedWork());
        this.addTabPanel(extensionHookView.getStatusPanel(), view.getWorkbench().getTabbedStatus());
        this.addParamPanel(extensionHookView.getSessionPanel(), view.getSessionDialog(""));
        this.addParamPanel(extensionHookView.getOptionsPanel(), view.getOptionsDialog(""));
    }

    private void initAllExtension() {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).init();
        }
    }

    private void initModelAllExtension(Model model) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).initModel(model);
        }
    }

    private void initViewAllExtension(View view) {
        if (view == null) {
            return;
        }
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).initView(view);
        }
    }

    private void initXMLAllExtension(Session session, OptionsParam optionsParam) {
        for (int i = 0; i < this.getExtensionCount(); ++i) {
            this.getExtension(i).initXML(session, optionsParam);
        }
    }
}

