/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;

public class PopupMenuExportMessage
extends ExtensionPopupMenu {
    private static final String CRLF = "\r\n";
    private ExtensionHistory extension = null;

    public PopupMenuExportMessage() {
        this.initialize();
    }

    public PopupMenuExportMessage(String string) {
        super(string);
    }

    private void initialize() {
        this.setText("Export Messages to File...");
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JList jList = PopupMenuExportMessage.this.extension.getLogPanel().getListLog();
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray.length == 0) {
                    PopupMenuExportMessage.this.extension.getView().showWarningDialog("Select HTTP messages in History panel before export to file.");
                    return;
                }
                File file = PopupMenuExportMessage.this.getOutputFile();
                if (file == null) {
                    return;
                }
                boolean bl = true;
                if (file.exists()) {
                    int n = PopupMenuExportMessage.this.extension.getView().showYesNoCancelDialog("File exists.  Yes = overwrite, No = append?");
                    if (n == 2) {
                        return;
                    }
                    if (n == 0) {
                        bl = false;
                    }
                }
                BufferedWriter bufferedWriter = null;
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file, bl));
                    for (int i = 0; i < objectArray.length; ++i) {
                        HistoryReference historyReference = (HistoryReference)objectArray[i];
                        PopupMenuExportMessage.this.exportHistory(historyReference, bufferedWriter);
                    }
                }
                catch (Exception exception) {
                    PopupMenuExportMessage.this.extension.getView().showWarningDialog("Error saving file to " + file.getAbsolutePath() + ".");
                }
                finally {
                    try {
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("ListLog")) {
            try {
                JList jList = (JList)component;
                if (jList.getSelectedIndex() >= 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private JTree getTree(Component component) {
        JTree jTree;
        if (component instanceof JTree && (jTree = (JTree)component).getName().equals("treeSite")) {
            return jTree;
        }
        return null;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void exportHistory(HistoryReference historyReference, Writer writer) {
        if (historyReference == null) {
            return;
        }
        String string = null;
        try {
            writer.write("==== " + historyReference.getHistoryId() + " ==========" + CRLF);
            string = historyReference.getHttpMessage().getRequestHeader().toString();
            writer.write(string);
            string = historyReference.getHttpMessage().getRequestBody().toString();
            writer.write(string);
            if (!string.endsWith(CRLF)) {
                writer.write(CRLF);
            }
            if (!historyReference.getHttpMessage().getResponseHeader().isEmpty()) {
                string = historyReference.getHttpMessage().getResponseHeader().toString();
                writer.write(string);
                string = historyReference.getHttpMessage().getResponseBody().toString();
                writer.write(string);
                if (!string.endsWith(CRLF)) {
                    writer.write(CRLF);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getOutputFile() {
        JFileChooser jFileChooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "ASCII text file";
            }
        });
        File file = null;
        int n = jFileChooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = file.getAbsolutePath();
            if (!string.endsWith(".txt")) {
                string = string + ".txt";
                file = new File(string);
            }
            return file;
        }
        return file;
    }
}

