/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportResponse
extends ExtensionPopupMenu {
    private ExtensionHistory extension = null;

    public PopupMenuExportResponse() {
        this.initialize();
    }

    public PopupMenuExportResponse(String string) {
        super(string);
    }

    private void initialize() {
        this.setText("Export Response to File...");
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JList jList = PopupMenuExportResponse.this.extension.getLogPanel().getListLog();
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray.length == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog("Select HTTP message in History panel before export to file.");
                    return;
                }
                if (objectArray.length > 1) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog("Only one response can be exported at a time.");
                    return;
                }
                HistoryReference historyReference = (HistoryReference)objectArray[0];
                HttpMessage httpMessage = null;
                try {
                    httpMessage = historyReference.getHttpMessage();
                }
                catch (Exception exception) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog("Error reading response.");
                    return;
                }
                if (httpMessage.getResponseHeader().isEmpty() || httpMessage.getResponseBody().length() == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog("Empty body.  File not created.");
                    return;
                }
                File file = PopupMenuExportResponse.this.getOutputFile(httpMessage);
                if (file == null) {
                    return;
                }
                boolean bl = true;
                if (file.exists()) {
                    int n = PopupMenuExportResponse.this.extension.getView().showYesNoCancelDialog("File exists.  Yes = overwrite, No = append?");
                    if (n == 2) {
                        return;
                    }
                    if (n == 0) {
                        bl = false;
                    }
                }
                FilterOutputStream filterOutputStream = null;
                try {
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
                    for (int i = 0; i < objectArray.length; ++i) {
                        PopupMenuExportResponse.this.exportHistory(httpMessage, (BufferedOutputStream)filterOutputStream);
                    }
                }
                catch (Exception exception) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog("Error saving file to " + file.getAbsolutePath() + ".");
                }
                finally {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("ListLog")) {
            try {
                JList jList = (JList)component;
                if (jList.getSelectedIndex() >= 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private JTree getTree(Component component) {
        JTree jTree;
        if (component instanceof JTree && (jTree = (JTree)component).getName().equals("treeSite")) {
            return jTree;
        }
        return null;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void exportHistory(HttpMessage httpMessage, BufferedOutputStream bufferedOutputStream) {
        try {
            if (!httpMessage.getResponseHeader().isEmpty()) {
                bufferedOutputStream.write(httpMessage.getResponseBody().getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File getOutputFile(HttpMessage httpMessage) {
        String string = "";
        try {
            string = httpMessage.getRequestHeader().getURI().getPath();
            int n = string.lastIndexOf("/");
            string = string.substring(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFileChooser jFileChooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        if (string.length() > 0) {
            jFileChooser.setSelectedFile(new File(string));
        }
        File file = null;
        int n = jFileChooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            return file;
        }
        return file;
    }
}

