/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.MenuFileControl;
import org.parosproxy.paros.control.MenuToolsControl;
import org.parosproxy.paros.view.AboutDialog;
import org.parosproxy.paros.view.View;

public class MainMenuBar
extends JMenuBar {
    private JMenu menuEdit = null;
    private JMenu menuTools = null;
    private JMenu menuView = null;
    private JMenuItem menuToolsOptions = null;
    private JMenu menuFile = null;
    private JMenuItem menuFileNewSession = null;
    private JMenuItem menuFileOpen = null;
    private JMenuItem menuFileSaveAs = null;
    private JMenuItem menuFileExit = null;
    private JMenuItem menuFileProperties = null;
    private JMenuItem menuFileSave = null;
    private JMenu menuHelp = null;
    private JMenuItem menuHelpAbout = null;
    private JMenu menuAnalyse = null;

    public MainMenuBar() {
        this.initialize();
    }

    private void initialize() {
        this.add(this.getMenuFile());
        this.add(this.getMenuEdit());
        this.add(this.getMenuView());
        this.add(this.getMenuAnalyse());
        this.add(this.getMenuTools());
        this.add(this.getMenuHelp());
    }

    public JMenu getMenuEdit() {
        if (this.menuEdit == null) {
            this.menuEdit = new JMenu();
            this.menuEdit.setText("Edit");
        }
        return this.menuEdit;
    }

    public JMenu getMenuTools() {
        if (this.menuTools == null) {
            this.menuTools = new JMenu();
            this.menuTools.setText("Tools");
            this.menuTools.addSeparator();
            this.menuTools.add(this.getMenuToolsOptions());
        }
        return this.menuTools;
    }

    public JMenu getMenuView() {
        if (this.menuView == null) {
            this.menuView = new JMenu();
            this.menuView.setText("View");
        }
        return this.menuView;
    }

    private JMenuItem getMenuToolsOptions() {
        if (this.menuToolsOptions == null) {
            this.menuToolsOptions = new JMenuItem();
            this.menuToolsOptions.setText("Options...");
            this.menuToolsOptions.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenuBar.this.getMenuToolsControl().options();
                }
            });
        }
        return this.menuToolsOptions;
    }

    public JMenu getMenuFile() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu();
            this.menuFile.setText("File");
            this.menuFile.setMnemonic(70);
            this.menuFile.add(this.getMenuFileNewSession());
            this.menuFile.add(this.getMenuFileOpen());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileSave());
            this.menuFile.add(this.getMenuFileSaveAs());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileProperties());
            this.menuFile.addSeparator();
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileExit());
        }
        return this.menuFile;
    }

    private JMenuItem getMenuFileNewSession() {
        if (this.menuFileNewSession == null) {
            this.menuFileNewSession = new JMenuItem();
            this.menuFileNewSession.setText("New Session");
            this.menuFileNewSession.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MainMenuBar.this.getMenuFileControl().newSession(true);
                        MainMenuBar.this.getMenuFileSave().setEnabled(false);
                    }
                    catch (Exception exception) {
                        View.getSingleton().showWarningDialog("Error creating new session");
                        exception.printStackTrace();
                    }
                }
            });
        }
        return this.menuFileNewSession;
    }

    private JMenuItem getMenuFileOpen() {
        if (this.menuFileOpen == null) {
            this.menuFileOpen = new JMenuItem();
            this.menuFileOpen.setText("Open Session...");
            this.menuFileOpen.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenuBar.this.getMenuFileControl().openSession();
                    MainMenuBar.this.getMenuFileSave().setEnabled(true);
                }
            });
        }
        return this.menuFileOpen;
    }

    private JMenuItem getMenuFileSaveAs() {
        if (this.menuFileSaveAs == null) {
            this.menuFileSaveAs = new JMenuItem();
            this.menuFileSaveAs.setText("Save As...");
            this.menuFileSaveAs.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenuBar.this.getMenuFileControl().saveAsSession();
                }
            });
        }
        return this.menuFileSaveAs;
    }

    private JMenuItem getMenuFileExit() {
        if (this.menuFileExit == null) {
            this.menuFileExit = new JMenuItem();
            this.menuFileExit.setText("Exit");
            this.menuFileExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenuBar.this.getMenuFileControl().exit();
                }
            });
        }
        return this.menuFileExit;
    }

    public MenuFileControl getMenuFileControl() {
        return Control.getSingleton().getMenuFileControl();
    }

    private MenuToolsControl getMenuToolsControl() {
        return Control.getSingleton().getMenuToolsControl();
    }

    private JMenuItem getMenuFileProperties() {
        if (this.menuFileProperties == null) {
            this.menuFileProperties = new JMenuItem();
            this.menuFileProperties.setText("Properties...");
            this.menuFileProperties.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenuBar.this.getMenuFileControl().properties();
                }
            });
        }
        return this.menuFileProperties;
    }

    public JMenuItem getMenuFileSave() {
        if (this.menuFileSave == null) {
            this.menuFileSave = new JMenuItem();
            this.menuFileSave.setText("Save");
            this.menuFileSave.setEnabled(false);
            this.menuFileSave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainMenuBar.this.getMenuFileControl().saveSession();
                }
            });
        }
        return this.menuFileSave;
    }

    private JMenu getMenuHelp() {
        if (this.menuHelp == null) {
            this.menuHelp = new JMenu();
            this.menuHelp.setText("Help");
            this.menuHelp.add(this.getMenuHelpAbout());
        }
        return this.menuHelp;
    }

    private JMenuItem getMenuHelpAbout() {
        if (this.menuHelpAbout == null) {
            this.menuHelpAbout = new JMenuItem();
            this.menuHelpAbout.setText("About Paros");
            this.menuHelpAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AboutDialog aboutDialog = new AboutDialog((Frame)View.getSingleton().getMainFrame(), true);
                    aboutDialog.setVisible(true);
                }
            });
        }
        return this.menuHelpAbout;
    }

    public JMenu getMenuAnalyse() {
        if (this.menuAnalyse == null) {
            this.menuAnalyse = new JMenu();
            this.menuAnalyse.setText("Analyse");
        }
        return this.menuAnalyse;
    }
}

