<?php

/**
 * BasePerformanceReview
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                   $id                                         Type: integer(6), primary key
 * @property int                                   $statusId                                   Type: integer(11)
 * @property int                                   $employeeNumber                             Type: integer(11)
 * @property string                                $workPeriodStart                            Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                                $workPeriodEnd                              Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property int                                   $jobTitleCode                               Type: integer
 * @property int                                   $departmentId                               Type: integer
 * @property string                                $dueDate                                    Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                                $completedDate                              Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @property string                                $activatedDate                              Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                $finalComment                               Type: clob(65532)
 * @property float                                 $finalRate                                  Type: decimal
 * @property Doctrine_Collection|ReviewerRating[]  $reviewerRating                             
 * @property Doctrine_Collection|Reviewer[]        $reviewers                                  
 * @property JobTitle                              $JobTitle                                   
 * @property Subunit                               $Department                                 
 * @property Employee                              $Employee                                   
 *  
 * @method int                                     getId()                                     Type: integer(6), primary key
 * @method int                                     getStatusid()                               Type: integer(11)
 * @method int                                     getEmployeenumber()                         Type: integer(11)
 * @method string                                  getWorkperiodstart()                        Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                                  getWorkperiodend()                          Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method int                                     getJobtitlecode()                           Type: integer
 * @method int                                     getDepartmentid()                           Type: integer
 * @method string                                  getDuedate()                                Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                                  getCompleteddate()                          Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method string                                  getActivateddate()                          Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                  getFinalcomment()                           Type: clob(65532)
 * @method float                                   getFinalrate()                              Type: decimal
 * @method Doctrine_Collection|ReviewerRating[]    getReviewerRating()                         
 * @method Doctrine_Collection|Reviewer[]          getReviewers()                              
 * @method JobTitle                                getJobTitle()                               
 * @method Subunit                                 getDepartment()                             
 * @method Employee                                getEmployee()                               
 *  
 * @method PerformanceReview                       setId(int $val)                             Type: integer(6), primary key
 * @method PerformanceReview                       setStatusid(int $val)                       Type: integer(11)
 * @method PerformanceReview                       setEmployeenumber(int $val)                 Type: integer(11)
 * @method PerformanceReview                       setWorkperiodstart(string $val)             Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method PerformanceReview                       setWorkperiodend(string $val)               Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method PerformanceReview                       setJobtitlecode(int $val)                   Type: integer
 * @method PerformanceReview                       setDepartmentid(int $val)                   Type: integer
 * @method PerformanceReview                       setDuedate(string $val)                     Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method PerformanceReview                       setCompleteddate(string $val)               Type: date, Date in ISO-8601 format (YYYY-MM-DD)
 * @method PerformanceReview                       setActivateddate(string $val)               Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method PerformanceReview                       setFinalcomment(string $val)                Type: clob(65532)
 * @method PerformanceReview                       setFinalrate(float $val)                    Type: decimal
 * @method PerformanceReview                       setReviewerRating(Doctrine_Collection $val) 
 * @method PerformanceReview                       setReviewers(Doctrine_Collection $val)      
 * @method PerformanceReview                       setJobTitle(JobTitle $val)                  
 * @method PerformanceReview                       setDepartment(Subunit $val)                 
 * @method PerformanceReview                       setEmployee(Employee $val)                  
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BasePerformanceReview extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_performance_review');
        $this->hasColumn('id', 'integer', 6, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 6,
             ));
        $this->hasColumn('status_id as statusId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('employee_number as employeeNumber', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('work_period_start as workPeriodStart', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('work_period_end as workPeriodEnd', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('job_title_code as jobTitleCode', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('department_id as departmentId', 'integer', null, array(
             'type' => 'integer',
             ));
        $this->hasColumn('due_date as dueDate', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('completed_date as completedDate', 'date', null, array(
             'type' => 'date',
             ));
        $this->hasColumn('activated_date as activatedDate', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('final_comment as finalComment', 'clob', 65532, array(
             'type' => 'clob',
             'length' => 65532,
             ));
        $this->hasColumn('final_rate as finalRate', 'decimal', null, array(
             'type' => 'decimal',
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('ReviewerRating as reviewerRating', array(
             'local' => 'id',
             'foreign' => 'review_id'));

        $this->hasMany('Reviewer as reviewers', array(
             'local' => 'id',
             'foreign' => 'review_id'));

        $this->hasOne('JobTitle', array(
             'local' => 'jobTitleCode',
             'foreign' => 'id'));

        $this->hasOne('Subunit as Department', array(
             'local' => 'departmentId',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'employee_number',
             'foreign' => 'emp_number'));
    }
}