/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.calendar;

import com.projectlibre1.pm.calendar.CalendarEvent;
import com.projectlibre1.pm.calendar.WorkingHours;
import com.projectlibre1.util.MathUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class WorkDay
extends CalendarEvent
implements Comparable,
Cloneable,
Serializable {
    static final long serialVersionUID = 28283927181117L;
    public static final WorkDay MINIMUM = new WorkDay(0L);
    public static final WorkDay MAXIMUM = new WorkDay(Long.MAX_VALUE);
    WorkingHours workingHours = new WorkingHours();
    private static WorkDay defaultWorkDay = null;
    private static WorkDay nonStopWorkDay = null;
    private static WorkDay nonWorkingWorkDay = null;

    public WorkDay(long l, long l2) {
        super(l, l2);
    }

    public Object clone() {
        WorkDay workDay = null;
        try {
            workDay = (WorkDay)super.clone();
            workDay.workingHours = (WorkingHours)this.workingHours.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return workDay;
    }

    public WorkDay(long l) {
        this(l, l);
    }

    public WorkDay() {
        this(0L, 0L);
    }

    WorkDay intersectWith(WorkDay workDay) {
        WorkDay workDay2 = new WorkDay(Math.max(this.getStart(), workDay.getStart()), Math.min(this.getStart(), workDay.getStart()));
        workDay2.setWorkingHours(this.workingHours.intersectWith(workDay.getWorkingHours()));
        return workDay2;
    }

    void initialize() {
        this.workingHours.initialize();
    }

    public WorkingHours getWorkingHours() {
        return this.workingHours;
    }

    public void setWorkingHours(WorkingHours workingHours) {
        this.workingHours = workingHours;
    }

    public boolean hasSameWorkHours(WorkDay workDay) {
        if (this.workingHours == null) {
            if (workDay == null || workDay.workingHours == null) {
                return true;
            }
            return workDay.hasSameWorkHours(this);
        }
        if (workDay == null) {
            return false;
        }
        return this.workingHours.equals(workDay.workingHours);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof WorkDay)) {
            return false;
        }
        return this.getStart() == ((WorkDay)object).getStart();
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object2 instanceof Date) {
            return MathUtils.signum(((WorkDay)object).getStart() - ((Date)object2).getTime());
        }
        if (object2 instanceof Calendar) {
            return MathUtils.signum(((WorkDay)object).getStart() - ((Calendar)object2).getTimeInMillis());
        }
        if (!(object instanceof WorkDay) || !(object2 instanceof WorkDay)) {
            return 0;
        }
        return MathUtils.signum(((WorkDay)object).getStart() - ((WorkDay)object2).getStart());
    }

    public long getDuration() {
        return this.workingHours.getDuration();
    }

    public boolean isWorking() {
        return this.getDuration() > 0L;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof WorkDay) {
            return MathUtils.signum(this.getStart() - ((WorkDay)object).getStart());
        }
        if (object instanceof Date) {
            return MathUtils.signum(this.getStart() - ((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return MathUtils.signum(this.getStart() - ((Calendar)object).getTimeInMillis());
        }
        throw new ClassCastException("Cant compare" + object + " to a WorkDay");
    }

    public String toString() {
        return "work day " + new Date(this.start) + " " + this.hashCode() + "\n" + this.workingHours.toString() + "\n";
    }

    public static WorkDay getDefaultWorkDay() {
        if (defaultWorkDay == null) {
            defaultWorkDay = new WorkDay();
            defaultWorkDay.setWorkingHours(WorkingHours.getDefault());
        }
        return defaultWorkDay;
    }

    public static WorkDay getNonStopWorkDay() {
        if (nonStopWorkDay == null) {
            nonStopWorkDay = new WorkDay();
            nonStopWorkDay.setWorkingHours(WorkingHours.getNonStop());
        }
        return nonStopWorkDay;
    }

    public static WorkDay getNonWorkingDay() {
        if (nonWorkingWorkDay == null) {
            nonWorkingWorkDay = new WorkDay();
        }
        return nonWorkingWorkDay;
    }
}

