/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.chart;

import com.projectlibre1.graphic.configuration.shape.Colors;
import com.projectlibre1.pm.assignment.TimeDistributedConstants;
import com.projectlibre1.util.Environment;
import java.awt.Color;
import java.util.HashMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.SeriesRenderingOrder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class ChartHelper
implements TimeDistributedConstants {
    public static final int BOTTOM_INSET = 7;
    private static HashMap map = null;

    public static JFreeChart createChart(XYDataset xYDataset, boolean bl, XYDataset xYDataset2) {
        JFreeChart jFreeChart = xYDataset2 != null ? ChartHelper.createBarLineChart(xYDataset, xYDataset2) : (bl ? ChartHelper.createBarChart(xYDataset) : ChartHelper.createLineChart(xYDataset));
        jFreeChart.setAntiAlias(false);
        jFreeChart.setBorderVisible(false);
        return jFreeChart;
    }

    public static JFreeChart createBarChart(XYDataset xYDataset) {
        NumberAxis numberAxis = null;
        NumberAxis numberAxis2 = new NumberAxis(null);
        numberAxis2.setAutoRangeIncludesZero(false);
        numberAxis = numberAxis2;
        NumberAxis numberAxis3 = new NumberAxis(null);
        XYStepAreaRenderer xYStepAreaRenderer = new XYStepAreaRenderer(2, new StandardXYToolTipGenerator(), null);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis3, xYStepAreaRenderer);
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, false);
        ChartHelper.removeAxisAndInsets(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBarLineChart(XYDataset xYDataset, XYDataset xYDataset2) {
        JFreeChart jFreeChart = ChartHelper.createBarChart(xYDataset);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
        jFreeChart.getXYPlot().setDataset(1, xYDataset2);
        jFreeChart.getXYPlot().setRenderer(1, standardXYItemRenderer);
        jFreeChart.getXYPlot().setSeriesRenderingOrder(SeriesRenderingOrder.FORWARD);
        jFreeChart.getXYPlot().setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        return jFreeChart;
    }

    public static JFreeChart createLineChart(XYDataset xYDataset) {
        NumberAxis numberAxis = new NumberAxis(null);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(null);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, standardXYItemRenderer);
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        standardXYItemRenderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        JFreeChart jFreeChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, false);
        ChartHelper.removeAxisAndInsets(jFreeChart);
        return jFreeChart;
    }

    public static void removeAxisAndInsets(JFreeChart jFreeChart) {
        XYPlot xYPlot = jFreeChart.getXYPlot();
        ChartHelper.removeAxisAndInsets(xYPlot);
    }

    public static void removeAxisAndInsets(XYPlot xYPlot) {
        xYPlot.getRangeAxis().setVisible(false);
        xYPlot.getDomainAxis().setVisible(false);
        xYPlot.setDomainGridlinesVisible(false);
        xYPlot.setInsets(new RectangleInsets(0.0, 0.0, 7.0, 0.0));
    }

    private static HashMap getMap() {
        if (map == null) {
            map = new HashMap();
            map.put(PERCENT_ALLOC, Colors.RED);
            map.put(OVERALLOCATED, Colors.RED);
            if (!Environment.getStandAlone()) {
                map.put(OTHER_PROJECTS, Colors.GRAY);
            }
            map.put(AVAILABILITY, Colors.BLACK);
            map.put(SELECTED, Colors.BLUE);
            map.put(THIS_PROJECT, Colors.GREEN);
            map.put(WORK, Colors.RED);
            map.put(ACTUAL_WORK, Colors.BROWN);
            map.put(REMAINING_WORK, Colors.PURPLE);
            map.put(BASELINE_WORK, Colors.DARK_SLATE_GRAY);
            map.put(COST, Colors.RED);
            map.put(ACTUAL_COST, Colors.BROWN);
            map.put(FIXED_COST, Colors.CORAL);
            map.put(ACTUAL_FIXED_COST, Colors.BURLY_WOOD);
            map.put(REMAINING_COST, Colors.PURPLE);
            map.put(BASELINE_COST, Colors.DARK_SLATE_GRAY);
            map.put(ACWP, Colors.RED);
            map.put(BCWP, Colors.OLIVE_DRAB);
            map.put(BCWS, Colors.GOLD);
            map.put(BASELINE1_WORK, Colors.MAGENTA);
            map.put(BASELINE2_WORK, Colors.KHAKI);
            map.put(BASELINE3_WORK, Colors.TAN);
            map.put(BASELINE4_WORK, Colors.NAVY);
            map.put(BASELINE5_WORK, Colors.TURQUOISE);
            map.put(BASELINE6_WORK, Colors.VIOLET);
            map.put(BASELINE7_WORK, Colors.MAROON);
            map.put(BASELINE8_WORK, Colors.SALMON);
            map.put(BASELINE9_WORK, Colors.ORANGE);
            map.put(BASELINE10_WORK, Colors.CYAN);
            map.put(BASELINE1_COST, Colors.MAGENTA);
            map.put(BASELINE2_COST, Colors.KHAKI);
            map.put(BASELINE3_COST, Colors.TAN);
            map.put(BASELINE4_COST, Colors.NAVY);
            map.put(BASELINE5_COST, Colors.TURQUOISE);
            map.put(BASELINE6_COST, Colors.VIOLET);
            map.put(BASELINE7_COST, Colors.MAROON);
            map.put(BASELINE8_COST, Colors.SALMON);
            map.put(BASELINE9_COST, Colors.ORANGE);
            map.put(BASELINE10_COST, Colors.CYAN);
        }
        return map;
    }

    public static Color getColorForField(Object object) {
        Color color = (Color)ChartHelper.getMap().get(object);
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }
}

