/*
 * Decompiled with CFR 0.152.
 */
package groovy.mock;

import com.mockobjects.Verifiable;
import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.CallBag;
import com.mockobjects.dynamic.CallFactory;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.DefaultCallFactory;
import com.mockobjects.dynamic.Mock;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.mock.ClosureConstraintMatcher;

public class GroovyMock
extends GroovyObjectSupport
implements Verifiable {
    private CallBag calls = new CallBag();
    private CallFactory callFactory = new DefaultCallFactory();
    private Mock mock = new Mock(I.class);
    private GroovyObject instance = new GroovyObjectSupport(){

        public Object invokeMethod(String name, Object args) {
            return GroovyMock.this.callMethod(name, args);
        }
    };

    public Object invokeMethod(String name, Object args) {
        if (name.equals("verify")) {
            this.verify();
        } else {
            this.expectMethod(name, args);
        }
        return null;
    }

    public GroovyObject getInstance() {
        return this.instance;
    }

    public static GroovyMock newInstance() {
        return new GroovyMock();
    }

    private void expectMethod(String name, Object args) {
        ConstraintMatcher constraintMatcher = this.createMatcher(args);
        this.calls.addExpect(this.callFactory.createCallExpectation(this.callFactory.createCallSignature(name, constraintMatcher, this.callFactory.createVoidStub())));
    }

    private ConstraintMatcher createMatcher(Object args) {
        Object[] argArray;
        if (args.getClass().isArray() && (argArray = (Object[])args)[0] instanceof Closure) {
            Closure closure = (Closure)argArray[0];
            return C.args((Constraint)new ClosureConstraintMatcher(closure));
        }
        return C.args((Constraint)C.eq((Object)args));
    }

    private Object callMethod(String name, Object args) {
        try {
            return this.calls.call(this.mock, name, new Object[]{args});
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void verify() {
        this.calls.verify();
    }

    static interface I {
    }
}

