module WebUnit

  # for Testing Framework
  unless const_defined?('AVAILABLE_FRAMEWORKS')
    AVAILABLE_FRAMEWORKS = []
  end
  
  [
    %w(Test::Unit test/unit/testcase),
    %w(RubyUnit runit/testcase),
  ].each do |framework|
    AVAILABLE_FRAMEWORKS.push(framework)
  end

  AVAILABLE_FRAMEWORKS.each do |name, library|
    begin
      require library
      USING_FRAMEWORK = name
      break
    rescue LoadError
    end
  end

  unless const_defined?('USING_FRAMEWORK')
    raise LoadError, 'require ' <<
      AVAILABLE_FRAMEWORKS.collect{|name,| name}.join(', ') <<
      "or #{AVAILABLE_FRAMEWORKS.last[0]}"
  end


  # for XML parser
  unless const_defined?('AVAILABLE_XMLPARSERS')
    AVAILABLE_XMLPARSERS = []
  end
  
  [
    %w(REXML rexml/document),
    %w(NQXML nqxml/treeparser),
  ].each do |xmlparser|
    AVAILABLE_XMLPARSERS.push(xmlparser)
  end

  AVAILABLE_XMLPARSERS.each do |name, library|
    begin
      require library
      USING_XMLPARSER = name
      break
    rescue LoadError
    end
  end

  unless const_defined?('USING_XMLPARSER')
    USING_XMLPARSER = 'none'
  end
end

case WebUnit::USING_FRAMEWORK
when 'Test::Unit'
  module Test
    module Unit
      module Assertions
        
        unless method_defined?('setup_assert')
          def setup_assert() add_assertion() end
        end

        unless method_defined?('raise_assertion_error')
          def raise_assertion_error(message)
            raise AssertionFailedError.new(message.to_s)
          end
        end

        [
          %w(assert_exception assert_raises),
          %w(assert_no_exception assert_nothing_raised),
          %w(assert_equals assert_equal),
          %w(assert_fail flunk),
          %w(assert_not_match assert_no_match),
          %w(assert_matches assert_match),
          %w(assert_equal_float assert_in_delta),
        ].each do |runit_method, testunit_method|
          unless method_defined?(runit_method)
            module_eval(<<-EOS)
            def #{runit_method}(*args, &block)
              add_assertion if @_assertion_wrapped
              #{testunit_method}(*args, &block)
            end
            EOS
          end
        end
        
        unless method_defined?('assert_equals')
          def assert_equals(*args, &block)
            add_assertion if @_assertion_wrapped
            assert_equal(*args, &block)
          end
        end

        unless method_defined?('assert_equals')
          def assert_equals(*args, &block)
            add_assertion if @_assertion_wrapped
            assert_equal(*args, &block)
          end
        end

        unless method_defined?('assert_equals')
          def assert_equals(*args, &block)
            add_assertion if @_assertion_wrapped
            assert_equal(*args, &block)
          end
        end

      end
    end
  end
when 'RubyUnit'
end

module WebUnit
  case USING_FRAMEWORK
  when 'Test::Unit'
    include Test::Unit::Assertions
    AssertionFailedError = Test::Unit::AssertionFailedError
    TestSuite = Test::Unit::TestSuite
    class TestCase < Test::Unit::TestCase
      private
      def add_assertion
        @_result.add_assertion if @_result
      end
    end
  when 'RubyUnit'
    include RUNIT::Assert
    AssertionFailedError = RUNIT::AssertionFailedError
    TestSuite = RUNIT::TestSuite
    class TestCase < RUNIT::TestCase
      class << self
        def test_cases
          if self == TestCase
            TestSuite.new(*@@test_classes)
          else
            suite
          end
        end
        alias all_suite test_cases
      end
    end
  end
end
