/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import java.security.PrivilegedExceptionAction;

final class ServiceProviderLoadingAction
implements PrivilegedExceptionAction {
    private final Class spi;
    private final String providerName;
    private final ClassLoader loader;

    public final Object run() throws Exception {
        Class loadedClass = this.loader.loadClass(this.providerName);
        Object serviceProvider = loadedClass.newInstance();
        if (!this.spi.isInstance(serviceProvider)) {
            throw new ClassCastException(this.spi.getName());
        }
        return serviceProvider;
    }

    ServiceProviderLoadingAction(Class spi, String providerName, ClassLoader loader) {
        if (spi == null || providerName == null || loader == null) {
            throw new IllegalArgumentException();
        }
        this.spi = spi;
        this.providerName = providerName;
        this.loader = loader;
    }
}

