/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;

public class SignerInfo {
    private static final boolean DEBUG = false;
    private final BigInteger version;
    private final BigInteger serialNumber;
    private final X500Principal issuer;
    private final OID digestAlgorithmId;
    private final byte[] digestAlgorithmParams;
    private final byte[] authenticatedAttributes;
    private final OID digestEncryptionAlgorithmId;
    private final byte[] digestEncryptionAlgorithmParams;
    private final byte[] encryptedDigest;
    private final byte[] unauthenticatedAttributes;

    private static final void debug(String msg) {
        System.err.print("SignerInfo >> ");
        System.err.println(msg);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public OID getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public byte[] getDigestAlgorithmParams() {
        return this.digestAlgorithmParams != null ? (byte[])this.digestAlgorithmParams.clone() : null;
    }

    public byte[] getAuthenticatedAttributes() {
        return this.authenticatedAttributes != null ? (byte[])this.authenticatedAttributes.clone() : null;
    }

    public OID getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getDigestEncryptionAlgorithmParams() {
        return this.digestEncryptionAlgorithmParams != null ? (byte[])this.digestEncryptionAlgorithmParams.clone() : null;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest != null ? (byte[])this.encryptedDigest.clone() : null;
    }

    public byte[] getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes != null ? (byte[])this.unauthenticatedAttributes.clone() : null;
    }

    public SignerInfo(BERReader ber) throws IOException {
        DERValue val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfo");
        }
        val = ber.read();
        if (val.getTag() != 2) {
            throw new BEREncodingException("malformed Version");
        }
        this.version = (BigInteger)val.getValue();
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed IssuerAndSerialNumber");
        }
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed Issuer");
        }
        this.issuer = new X500Principal(val.getEncoded());
        ber.skip(val.getLength());
        val = ber.read();
        if (val.getTag() != 2) {
            throw new BEREncodingException("malformed SerialNumber");
        }
        this.serialNumber = (BigInteger)val.getValue();
        val = ber.read();
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifier");
        }
        boolean count = false;
        DERValue val2 = ber.read();
        if (val2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestAlgorithmId = (OID)val2.getValue();
        if (BERValue.isIndefinite(val)) {
            val2 = ber.read();
            if (val2 != BER.END_OF_SEQUENCE) {
                this.digestAlgorithmParams = val2.getEncoded();
                val2 = ber.read();
                if (val2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestAlgorithmParams = null;
            }
        } else if (val2.getEncodedLength() < val.getLength()) {
            val2 = ber.read();
            this.digestAlgorithmParams = val2.getEncoded();
            if (val2.isConstructed()) {
                ber.skip(val2.getLength());
            }
        } else {
            this.digestAlgorithmParams = null;
        }
        val = ber.read();
        if (val.getTag() == 0) {
            this.authenticatedAttributes = val.getEncoded();
            val = ber.read();
            if (val.isConstructed()) {
                ber.skip(val.getLength());
            }
            val = ber.read();
        } else {
            this.authenticatedAttributes = null;
        }
        if (!val.isConstructed()) {
            throw new BEREncodingException("malformed DigestEncryptionAlgorithmIdentifier");
        }
        count = false;
        val2 = ber.read();
        if (val2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestEncryptionAlgorithmId = (OID)val2.getValue();
        if (BERValue.isIndefinite(val)) {
            val2 = ber.read();
            if (val2 != BER.END_OF_SEQUENCE) {
                this.digestEncryptionAlgorithmParams = val2.getEncoded();
                val2 = ber.read();
                if (val2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestEncryptionAlgorithmParams = null;
            }
        } else if (val2.getEncodedLength() < val.getLength()) {
            val2 = ber.read();
            this.digestEncryptionAlgorithmParams = val2.getEncoded();
            if (val2.isConstructed()) {
                ber.skip(val2.getLength());
            }
        } else {
            this.digestEncryptionAlgorithmParams = null;
        }
        val = ber.read();
        if (val.getTag() != 4) {
            throw new BEREncodingException("malformed EncryptedDigest");
        }
        this.encryptedDigest = (byte[])val.getValue();
        this.unauthenticatedAttributes = (byte[])(ber.peek() == 1 ? ber.read().getEncoded() : null);
        if (ber.peek() == 0) {
            ber.read();
        }
    }
}

