/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.aelfred2.ContentHandler2;
import gnu.xml.dom.DomAttr;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class SAXEventSink
implements ContentHandler2,
LexicalHandler,
DTDHandler,
DeclHandler {
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XMLNS_PREFIX = "xmlns";
    boolean namespaceAware;
    boolean ignoreWhitespace;
    boolean expandEntityReferences;
    boolean ignoreComments;
    boolean coalescing;
    DomDocument doc;
    Node ctx;
    LinkedList entityCtx;
    List pending;
    Locator locator;
    boolean inCDATA;
    boolean inDTD;
    boolean interrupted;

    void interrupt() {
        this.interrupted = true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.namespaceAware) {
            this.pending = new LinkedList();
        }
        this.doc = new DomDocument();
        this.doc.setStrictErrorChecking(false);
        this.doc.setBuilding(true);
        this.ctx = this.doc;
    }

    public void xmlDecl(String version, String encoding, boolean standalone, String inputEncoding) throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.doc.setXmlVersion(version);
        this.doc.setXmlEncoding(encoding);
        this.doc.setXmlStandalone(standalone);
        this.doc.setInputEncoding(inputEncoding);
    }

    public void endDocument() throws SAXException {
        this.doc.setStrictErrorChecking(true);
        this.doc.setBuilding(false);
        DomDoctype doctype = (DomDoctype)this.doc.getDoctype();
        if (doctype != null) {
            doctype.makeReadonly();
        }
        this.ctx = null;
        this.locator = null;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.namespaceAware) {
            String nsName = prefix != null && prefix.length() > 0 ? "xmlns:" + prefix : XMLNS_PREFIX;
            DomAttr ns = (DomAttr)this.doc.createAttributeNS(XMLNS_URI, nsName);
            ns.setNodeValue(uri);
            if (this.ctx.getNodeType() == 2) {
                Element target = ((Attr)this.ctx).getOwnerElement();
                target.getAttributes().setNamedItemNS(ns);
            } else {
                this.pending.add(ns);
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Element element = this.createElement(uri, localName, qName, atts);
        this.ctx.appendChild(element);
        this.ctx = element;
    }

    protected Element createElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Element element = this.namespaceAware ? this.doc.createElementNS(uri, qName) : this.doc.createElement(qName);
        NamedNodeMap attrs = element.getAttributes();
        if (this.namespaceAware && !this.pending.isEmpty()) {
            Iterator i = this.pending.iterator();
            while (i.hasNext()) {
                Node ns = (Node)i.next();
                attrs.setNamedItemNS(ns);
            }
            this.pending.clear();
        }
        int len = atts.getLength();
        int i = 0;
        while (i < len) {
            Attr attr = this.createAttr(atts, i);
            if (attr != null) {
                if (this.namespaceAware) {
                    attrs.setNamedItemNS(attr);
                } else {
                    attrs.setNamedItem(attr);
                }
            }
            ++i;
        }
        return element;
    }

    protected Attr createAttr(Attributes atts, int index) {
        DomAttr attr;
        if (this.namespaceAware) {
            String a_uri = atts.getURI(index);
            String a_qName = atts.getQName(index);
            attr = (DomAttr)this.doc.createAttributeNS(a_uri, a_qName);
        } else {
            String a_qName = atts.getQName(index);
            attr = (DomAttr)this.doc.createAttribute(a_qName);
        }
        attr.setNodeValue(atts.getValue(index));
        if (atts instanceof Attributes2) {
            Attributes2 atts2 = (Attributes2)atts;
            attr.setSpecified(atts2.isSpecified(index));
        }
        return attr;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (this.namespaceAware) {
            this.pending.clear();
        }
        this.ctx = this.ctx.getParentNode();
    }

    public void characters(char[] c, int off, int len) throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.ctx.appendChild(this.createText(c, off, len));
    }

    protected Text createText(char[] c, int off, int len) throws SAXException {
        Text text = this.inCDATA && !this.coalescing ? this.doc.createCDATASection(new String(c, off, len)) : this.doc.createTextNode(new String(c, off, len));
        return text;
    }

    public void ignorableWhitespace(char[] c, int off, int len) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.ignoreWhitespace) {
            this.characters(c, off, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            Node pi = this.createProcessingInstruction(target, data);
            this.ctx.appendChild(pi);
        }
    }

    protected Node createProcessingInstruction(String target, String data) {
        return this.doc.createProcessingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.interrupted) {
            return;
        }
        Node doctype = this.createDocumentType(name, publicId, systemId);
        this.doc.appendChild(doctype);
        this.ctx = doctype;
        this.inDTD = true;
    }

    protected Node createDocumentType(String name, String publicId, String systemId) {
        return new DomDoctype(this.doc, name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        if (this.interrupted) {
            return;
        }
        this.inDTD = false;
        this.ctx = this.ctx.getParentNode();
    }

    public void startEntity(String name) throws SAXException {
        DocumentType doctype = this.doc.getDoctype();
        if (doctype == null) {
            throw new SAXException("SAX parser error: reference to entity in undeclared doctype");
        }
        if ("[dtd]".equals(name) || name.charAt(0) == '%') {
            this.ctx = doctype;
            return;
        }
        if ("lt".equals(name) || "gt".equals(name) || "amp".equals(name) || "apos".equals(name) || "quot".equals(name)) {
            return;
        }
        NamedNodeMap entities = doctype.getEntities();
        Entity entity = (Entity)entities.getNamedItem(name);
        if (entity == null) {
            throw new SAXException("SAX parser error: reference to undeclared entity: " + name);
        }
        this.pushEntity(entity);
    }

    public void endEntity(String name) throws SAXException {
        if ("[dtd]".equals(name) || name.charAt(0) == '%') {
            return;
        }
        if ("lt".equals(name) || "gt".equals(name) || "amp".equals(name) || "apos".equals(name) || "quot".equals(name)) {
            return;
        }
        Entity entity = this.popEntity();
        if (this.expandEntityReferences) {
            Node child = entity.getFirstChild();
            while (child != null) {
                this.ctx.appendChild(child);
                child = child.getNextSibling();
            }
        } else {
            EntityReference entityReference = this.doc.createEntityReference(name);
            this.ctx.appendChild(entityReference);
        }
    }

    void pushEntity(Node entity) {
        if (this.entityCtx == null) {
            this.entityCtx = new LinkedList();
        }
        this.entityCtx.addLast(this.ctx);
        this.ctx = entity;
    }

    Entity popEntity() {
        Entity ret = (Entity)this.ctx;
        this.ctx = (Node)this.entityCtx.removeLast();
        return ret;
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void comment(char[] c, int off, int len) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!this.inDTD) {
            Node comment = this.createComment(c, off, len);
            this.ctx.appendChild(comment);
        }
    }

    protected Node createComment(char[] c, int off, int len) {
        return this.doc.createComment(new String(c, off, len));
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.declareNotation(name, publicId, systemId);
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        Entity entity = doctype.declareEntity(name, publicId, systemId, notationName);
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.interrupted) {
            return;
        }
        if (!(this.ctx instanceof DomDoctype)) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.elementDecl(name, model);
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        doctype.attributeDecl(eName, aName, type, mode, value);
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        Entity entity = doctype.declareEntity(name, null, null, null);
        if (entity != null) {
            Text text = this.doc.createTextNode(value);
            entity.appendChild(text);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.interrupted) {
            return;
        }
        DomDoctype doctype = (DomDoctype)this.ctx;
        Entity entity = doctype.declareEntity(name, publicId, systemId, null);
    }

    SAXEventSink() {
    }
}

