/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.XSLURIResolver;
import gnu.xml.xpath.Constant;
import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Function;
import gnu.xml.xpath.IdFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.Node;

final class DocumentFunction
extends Expr
implements Function,
XPathFunction {
    final Stylesheet stylesheet;
    final Node base;
    List args;
    List values;

    public final Object evaluate(List args) throws XPathFunctionException {
        this.values = args;
        return this.evaluate(null, 1, 1);
    }

    public final void setArguments(List args) {
        this.args = args;
    }

    public final Object evaluate(Node context, int pos, int len) {
        Collection ret;
        Object arg;
        int arity = this.args.size();
        if (this.values == null) {
            this.values = new ArrayList(arity);
            int i = 0;
            while (i < arity) {
                arg = (Expr)this.args.get(i);
                this.values.add(((Expr)arg).evaluate(context, pos, len));
                ++i;
            }
        }
        switch (arity) {
            case 1: {
                arg = this.values.get(0);
                if (arg instanceof Collection) {
                    Collection ns = (Collection)arg;
                    TreeSet acc = new TreeSet();
                    Iterator i = ns.iterator();
                    while (i.hasNext()) {
                        Node node2 = (Node)i.next();
                        String s = Expr.stringValue(node2);
                        acc.addAll(this.document(s, node2.getBaseURI()));
                    }
                    ret = acc;
                    break;
                }
                String s = Expr._string(context, arg);
                ret = this.document(s, this.base.getBaseURI());
                break;
            }
            case 2: {
                String base2;
                Object arg1 = this.values.get(0);
                Object arg2 = this.values.get(1);
                if (!(arg2 instanceof Collection)) {
                    throw new RuntimeException("second argument is not a node-set");
                }
                Collection arg2ns = (Collection)arg2;
                String string = base2 = arg2ns.isEmpty() ? null : ((Node)arg2ns.iterator().next()).getBaseURI();
                if (arg1 instanceof Collection) {
                    Collection arg1ns = (Collection)arg1;
                    TreeSet acc = new TreeSet();
                    Iterator i = arg1ns.iterator();
                    while (i.hasNext()) {
                        Node node3 = (Node)i.next();
                        String s = Expr.stringValue(node3);
                        acc.addAll(this.document(s, base2));
                    }
                    ret = acc;
                    break;
                }
                String s = Expr._string(context, arg1);
                ret = this.document(s, base2);
                break;
            }
            default: {
                throw new RuntimeException("invalid arity");
            }
        }
        this.values = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Collection document(String uri, String base) {
        if ("".equals(uri) || uri == null) {
            uri = this.base.getBaseURI();
        }
        IdFunction fragment = null;
        int hi = uri.indexOf(35);
        if (hi != -1) {
            String f = uri.substring(hi + 1);
            uri = uri.substring(0, hi);
            fragment = new IdFunction(new Constant(f));
        }
        try {
            Node node2;
            block10: {
                XSLURIResolver resolver = this.stylesheet.factory.resolver;
                XSLURIResolver xSLURIResolver = resolver;
                synchronized (xSLURIResolver) {
                    if (this.stylesheet.transformer != null) {
                        resolver.setUserResolver(this.stylesheet.transformer.uriResolver);
                        resolver.setUserListener(this.stylesheet.transformer.errorListener);
                    }
                    DOMSource source = resolver.resolveDOM(null, base, uri);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var7_9
                    node2 = source.getNode();
                    if (fragment != null) break block10;
                    return Collections.singleton(node2);
                }
            }
            Object ret = ((Expr)fragment).evaluate(node2, 1, 1);
            if (ret instanceof Collection) return (Collection)ret;
            return Collections.EMPTY_SET;
        }
        catch (TransformerException e) {
            String msg = "can't open " + uri;
            if (base == null) throw new RuntimeException(msg);
            msg = msg + " with base " + base;
            throw new RuntimeException(msg);
        }
    }

    public final Expr clone(Object context) {
        Stylesheet s = this.stylesheet;
        if (context instanceof Stylesheet) {
            s = (Stylesheet)context;
        }
        DocumentFunction f = new DocumentFunction(s, this.base);
        int len = this.args.size();
        ArrayList args2 = new ArrayList(len);
        int i = 0;
        while (i < len) {
            args2.add(((Expr)this.args.get(i)).clone(context));
            ++i;
        }
        f.setArguments(args2);
        return f;
    }

    public final boolean references(QName var) {
        Iterator i = this.args.iterator();
        while (i.hasNext()) {
            if (!((Expr)i.next()).references(var)) continue;
            return true;
        }
        return false;
    }

    DocumentFunction(Stylesheet stylesheet, Node base) {
        this.stylesheet = stylesheet;
        this.base = base;
    }
}

