/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class PrintWriter
extends Writer {
    private static final char[] line_separator = System.getProperty("line.separator").toCharArray();
    private boolean autoflush;
    private boolean error;
    private boolean closed;
    protected Writer out;

    protected void setError() {
        this.error = true;
    }

    public boolean checkError() {
        if (!this.closed) {
            this.flush();
        }
        return this.error;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            this.error = true;
        }
    }

    public void close() {
        try {
            this.out.close();
            this.closed = true;
        }
        catch (IOException ex) {
            this.error = true;
        }
    }

    public void print(String str) {
        this.write(str == null ? "null" : str);
    }

    public void print(char ch) {
        this.write(ch);
    }

    public void print(char[] charArray) {
        this.write(charArray, 0, charArray.length);
    }

    public void print(boolean bool) {
        this.write(bool ? "true" : "false");
    }

    public void print(int inum) {
        this.write(Integer.toString(inum));
    }

    public void print(long lnum) {
        this.write(Long.toString(lnum));
    }

    public void print(float fnum) {
        this.write(Float.toString(fnum));
    }

    public void print(double dnum) {
        this.write(Double.toString(dnum));
    }

    public void print(Object obj) {
        this.write(obj == null ? "null" : obj.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.write(line_separator, 0, line_separator.length);
                if (this.autoflush) {
                    this.out.flush();
                }
            }
            catch (IOException ex) {
                this.error = true;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(boolean bool) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bool);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(int inum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(inum);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(long lnum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(lnum);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(float fnum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(fnum);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(double dnum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(dnum);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            this.print(obj);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(String str) {
        Object object = this.lock;
        synchronized (object) {
            this.print(str);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(char ch) {
        Object object = this.lock;
        synchronized (object) {
            this.print(ch);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void println(char[] charArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(charArray);
            this.println();
            return;
        }
    }

    public void write(int ch) {
        try {
            this.out.write(ch);
        }
        catch (IOException ex) {
            this.error = true;
        }
    }

    public void write(char[] charArray, int offset, int count) {
        try {
            this.out.write(charArray, offset, count);
        }
        catch (IOException ex) {
            this.error = true;
        }
    }

    public void write(String str, int offset, int count) {
        try {
            this.out.write(str, offset, count);
        }
        catch (IOException ex) {
            this.error = true;
        }
    }

    public void write(char[] charArray) {
        this.write(charArray, 0, charArray.length);
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public PrintWriter(Writer wr) {
        super(wr.lock);
        this.out = wr;
    }

    public PrintWriter(Writer wr, boolean autoflush) {
        super(wr.lock);
        this.out = wr;
        this.autoflush = autoflush;
    }

    public PrintWriter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
        this.lock = this.out;
    }

    public PrintWriter(OutputStream out, boolean autoflush) {
        this(out);
        this.autoflush = autoflush;
    }

    public PrintWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PrintWriter(String file, String enc) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), enc));
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PrintWriter(File file, String enc) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), enc));
    }
}

