/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String buf;
    private int pos;
    private int markedPos;
    private int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.markedPos = this.pos;
            return;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (this.pos < this.count) {
                return this.buf.charAt(this.pos++) & (char)-1;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.pos >= this.count) {
                return -1;
            }
            int lastChar = Math.min(this.count, this.pos + len);
            this.buf.getChars(this.pos, lastChar, b, off);
            int numChars = lastChar - this.pos;
            this.pos = lastChar;
            return numChars;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            this.pos = this.markedPos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(long n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("Stream closed");
            }
            long numChars = Math.min((long)(this.count - this.pos), n < 0L ? 0L : n);
            this.pos = (int)((long)this.pos + numChars);
            return numChars;
        }
    }

    public StringReader(String buffer) {
        this.buf = buffer;
        this.count = buffer.length();
        this.pos = 0;
        this.markedPos = 0;
    }
}

