/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;

public abstract class Authenticator {
    private static Authenticator defaultAuthenticator;
    private String host;
    private InetAddress addr;
    private int port;
    private String protocol;
    private String prompt;
    private String scheme;

    public static void setDefault(Authenticator defAuth) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new NetPermission("setDefaultAuthenticator"));
        }
        defaultAuthenticator = defAuth;
    }

    public static PasswordAuthentication requestPasswordAuthentication(InetAddress addr, int port, String protocol, String prompt, String scheme) throws SecurityException {
        return Authenticator.requestPasswordAuthentication(null, addr, port, protocol, prompt, scheme);
    }

    public static PasswordAuthentication requestPasswordAuthentication(String host, InetAddress addr, int port, String protocol, String prompt, String scheme) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new NetPermission("requestPasswordAuthentication"));
        }
        if (defaultAuthenticator == null) {
            return null;
        }
        Authenticator.defaultAuthenticator.host = host;
        Authenticator.defaultAuthenticator.addr = addr;
        Authenticator.defaultAuthenticator.port = port;
        Authenticator.defaultAuthenticator.protocol = protocol;
        Authenticator.defaultAuthenticator.prompt = prompt;
        Authenticator.defaultAuthenticator.scheme = scheme;
        return defaultAuthenticator.getPasswordAuthentication();
    }

    protected final InetAddress getRequestingSite() {
        return this.addr;
    }

    protected final String getRequestingHost() {
        return this.host;
    }

    protected final int getRequestingPort() {
        return this.port;
    }

    protected final String getRequestingProtocol() {
        return this.protocol;
    }

    protected final String getRequestingPrompt() {
        return this.prompt;
    }

    protected final String getRequestingScheme() {
        return this.scheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }
}

