/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.LongBuffer;

final class LongBufferImpl
extends LongBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final LongBuffer slice() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final LongBuffer duplicate() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final LongBuffer asReadOnlyBuffer() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final LongBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final long get() {
        this.checkForUnderflow();
        long result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final LongBuffer put(long value) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final long get(int index) {
        this.checkIndex(index);
        return this.backing_buffer[index];
    }

    public final LongBuffer put(int index, long value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    LongBufferImpl(int capacity) {
        this(new long[capacity], 0, capacity, capacity, 0, -1, false);
    }

    LongBufferImpl(long[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark);
        this.backing_buffer = buffer;
        this.array_offset = offset;
        this.readOnly = readOnly;
    }
}

