/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    private static final String SERVICE = "Mac";
    private MacSpi macSpi;
    private Provider provider;
    private String algorithm;
    private boolean virgin;

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] provs = Security.getProviders();
        String msg = "";
        int i = 0;
        while (i < provs.length) {
            try {
                return Mac.getInstance(algorithm, provs[i]);
            }
            catch (NoSuchAlgorithmException nsae) {
                msg = nsae.getMessage();
                ++i;
            }
        }
        throw new NoSuchAlgorithmException(msg);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Mac.getInstance(algorithm, p);
    }

    public static final Mac getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new Mac((MacSpi)Engine.getInstance(SERVICE, algorithm, provider), provider, algorithm);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() == null) {
                throw new NoSuchAlgorithmException(algorithm);
            }
            if (ite.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ite.getCause();
            }
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        byte[] digest = this.macSpi.engineDoFinal();
        this.reset();
        return digest;
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        this.update(input);
        byte[] digest = this.macSpi.engineDoFinal();
        this.reset();
        return digest;
    }

    public final void doFinal(byte[] output, int outOffset) throws IllegalStateException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        if (output.length - outOffset < this.getMacLength()) {
            throw new ShortBufferException();
        }
        byte[] mac = this.macSpi.engineDoFinal();
        System.arraycopy(mac, 0, output, outOffset, this.getMacLength());
        this.reset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new IllegalArgumentException(this.algorithm + " needs parameters");
        }
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.macSpi.engineInit(key, params);
        this.virgin = false;
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final void update(byte input) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        this.update(input, 0, input.length);
    }

    public final void update(byte[] input, int offset, int length) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(input, offset, length);
    }

    public final Object clone() throws CloneNotSupportedException {
        Mac result = new Mac((MacSpi)this.macSpi.clone(), this.provider, this.algorithm);
        result.virgin = this.virgin;
        return result;
    }

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.virgin = true;
    }
}

