/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.zip.Adler32;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;

public abstract class Certificate {
    public boolean equals(Object other) {
        if (other == null || !(other instanceof Certificate)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        try {
            return Arrays.equals(this.getEncoded(), ((Certificate)other).getEncoded());
        }
        catch (CertificateEncodingException cee) {
            return false;
        }
    }

    public int hashCode() {
        try {
            Adler32 csum = new Adler32();
            csum.update(this.getEncoded());
            return (int)csum.getValue();
        }
        catch (CertificateEncodingException cee) {
            return 0;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();
}

