/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.HashSet;
import java.util.Vector;
import javax.sound.midi.MidiEvent;

public class Track {
    protected Vector events;
    private HashSet eventSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean add(MidiEvent event) {
        Vector vector = this.events;
        synchronized (vector) {
            if (this.eventSet.contains(event)) {
                return false;
            }
            this.eventSet.add(event);
            long targetTick = event.getTick();
            int i = this.events.size() - 1;
            while (i >= 0 && ((MidiEvent)this.events.get(i)).getTick() > targetTick) {
                --i;
            }
            this.events.add(i + 1, event);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(MidiEvent event) {
        Vector vector = this.events;
        synchronized (vector) {
            if (!this.eventSet.remove(event)) {
                return false;
            }
            int i = this.events.indexOf(event);
            if (i >= 0) {
                this.events.remove(i);
                return true;
            }
            throw new InternalError("event in set but not list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MidiEvent get(int index) throws ArrayIndexOutOfBoundsException {
        Vector vector = this.events;
        synchronized (vector) {
            try {
                return (MidiEvent)this.events.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                throw (ArrayIndexOutOfBoundsException)new ArrayIndexOutOfBoundsException().initCause(e);
            }
        }
    }

    public int size() {
        return this.events.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long ticks() {
        Vector vector = this.events;
        synchronized (vector) {
            int size = this.events.size();
            return ((MidiEvent)this.events.get(size - 1)).getTick();
        }
    }
}

