/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    MainSwatchPanel mainPalette;
    RecentSwatchPanel recentPalette;
    MouseListener mouseHandler;

    public void updateChooser() {
    }

    protected void buildChooser() {
        this.setLayout(new MainPanelLayout());
        JPanel mainPaletteHolder = new JPanel();
        JPanel recentPaletteHolder = new JPanel();
        this.mainPalette = new MainSwatchPanel();
        this.recentPalette = new RecentSwatchPanel();
        JLabel label = new JLabel("Recent:");
        this.mouseHandler = new MouseHandler();
        this.mainPalette.addMouseListener(this.mouseHandler);
        this.recentPalette.addMouseListener(this.mouseHandler);
        mainPaletteHolder.setLayout(new BorderLayout());
        mainPaletteHolder.add((Component)this.mainPalette, "Center");
        recentPaletteHolder.setLayout(new RecentPanelLayout());
        recentPaletteHolder.add(label);
        recentPaletteHolder.add(this.recentPalette);
        JPanel main = new JPanel();
        main.add(mainPaletteHolder);
        main.add(recentPaletteHolder);
        this.add(main);
    }

    public void uninstallChooserPanel(JColorChooser chooser) {
        this.recentPalette = null;
        this.mainPalette = null;
        this.removeAll();
        super.uninstallChooserPanel(chooser);
    }

    public String getDisplayName() {
        return "Swatches";
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public String getToolTipText(MouseEvent e) {
        return null;
    }

    DefaultSwatchChooserPanel() {
    }

    static class MainPanelLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Component[] comps = parent.getComponents();
            Insets insets = parent.getInsets();
            Dimension[] pref = new Dimension[comps.length];
            int xpos = 0;
            int ypos = 0;
            int maxHeight = 0;
            int totalWidth = 0;
            int i = 0;
            while (i < comps.length) {
                pref[i] = comps[i].getPreferredSize();
                if (pref[i] == null) {
                    return;
                }
                maxHeight = Math.max(maxHeight, pref[i].height);
                totalWidth += pref[i].width;
                ++i;
            }
            ypos = (parent.getSize().height - maxHeight) / 2 + insets.top;
            xpos = insets.left + (parent.getSize().width - totalWidth) / 2;
            i = 0;
            while (i < comps.length) {
                if (pref[i] != null) {
                    comps[i].setBounds(xpos, ypos, pref[i].width, pref[i].height);
                    xpos += pref[i].width;
                }
                ++i;
            }
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            int xmax = 0;
            int ymax = 0;
            Component[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                Dimension pref = comps[i].getPreferredSize();
                if (pref != null) {
                    xmax += pref.width;
                    ymax = Math.max(ymax, pref.height);
                }
                ++i;
            }
            Insets insets = parent.getInsets();
            return new Dimension(insets.left + insets.right + xmax, insets.top + insets.bottom + ymax);
        }

        MainPanelLayout() {
        }
    }

    static class MainSwatchPanel
    extends SwatchPanel {
        public static final Color C204255255 = new Color(204, 204, 255);
        public static final Color C255204204 = new Color(255, 204, 204);
        public static final Color C204255204 = new Color(204, 255, 204);
        public static final Color C204204204 = new Color(204, 204, 204);
        public static final Color C153153255 = new Color(153, 153, 255);
        public static final Color C051051255 = new Color(51, 51, 255);
        public static final Color C153000153 = new Color(153, 0, 153);
        public static final Color C000051051 = new Color(0, 51, 51);
        public static final Color C051000051 = new Color(51, 0, 51);
        public static final Color C051051000 = new Color(51, 51, 0);
        public static final Color C102102000 = new Color(102, 102, 0);
        public static final Color C153255153 = new Color(153, 255, 153);
        public static final Color C102255102 = new Color(102, 255, 102);
        public static final Color C000102102 = new Color(0, 102, 102);
        public static final Color C102000102 = new Color(102, 0, 102);
        public static final Color C000153153 = new Color(0, 153, 153);
        public static final Color C153153000 = new Color(153, 153, 0);
        public static final Color C204204000 = new Color(204, 204, 0);
        public static final Color C204000204 = new Color(204, 0, 204);
        public static final Color C000204204 = new Color(0, 204, 204);
        public static final Color C051255051 = new Color(51, 255, 51);
        public static final Color C255051051 = new Color(255, 51, 51);
        public static final Color C255102102 = new Color(255, 102, 102);
        public static final Color C102102255 = new Color(102, 102, 255);
        public static final Color C255153153 = new Color(255, 153, 153);
        static Color[] colors = new Color[]{Color.WHITE, new Color(204, 255, 255), C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, C204255255, new Color(255, 204, 255), C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, C255204204, new Color(255, 255, 204), C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204255204, C204204204, new Color(153, 255, 255), new Color(153, 204, 255), C153153255, C153153255, C153153255, C153153255, C153153255, C153153255, C153153255, new Color(204, 153, 255), new Color(255, 153, 255), new Color(255, 153, 204), C255153153, C255153153, C255153153, C255153153, C255153153, C255153153, C255153153, new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 153), C153255153, C153255153, C153255153, C153255153, C153255153, C153255153, C153255153, new Color(153, 255, 204), C204204204, new Color(102, 255, 255), new Color(102, 204, 255), new Color(102, 153, 255), C102102255, C102102255, C102102255, C102102255, C102102255, new Color(153, 102, 255), new Color(204, 102, 255), new Color(255, 102, 255), new Color(255, 102, 204), new Color(255, 102, 153), C255102102, C255102102, C255102102, C255102102, C255102102, new Color(255, 153, 102), new Color(255, 204, 102), new Color(255, 255, 102), new Color(204, 255, 102), new Color(153, 255, 102), C102255102, C102255102, C102255102, C102255102, C102255102, new Color(102, 255, 153), new Color(102, 255, 204), new Color(153, 153, 153), new Color(51, 255, 255), new Color(51, 204, 255), new Color(51, 153, 255), new Color(51, 102, 255), C051051255, C051051255, C051051255, new Color(102, 51, 255), new Color(153, 51, 255), new Color(204, 51, 255), new Color(255, 51, 255), new Color(255, 51, 204), new Color(255, 51, 153), new Color(255, 51, 102), C255051051, C255051051, C255051051, new Color(255, 102, 51), new Color(255, 153, 51), new Color(255, 204, 51), new Color(255, 255, 51), new Color(204, 255, 51), new Color(153, 255, 51), new Color(102, 255, 51), C051255051, C051255051, C051255051, new Color(51, 255, 102), new Color(51, 255, 153), new Color(51, 255, 204), new Color(153, 153, 153), new Color(0, 255, 255), new Color(0, 204, 255), new Color(0, 153, 255), new Color(0, 102, 255), new Color(0, 51, 255), new Color(0, 0, 255), new Color(51, 0, 255), new Color(102, 0, 255), new Color(153, 0, 255), new Color(204, 0, 255), new Color(255, 0, 255), new Color(255, 0, 204), new Color(255, 0, 153), new Color(255, 0, 102), new Color(255, 0, 51), new Color(255, 0, 0), new Color(255, 51, 0), new Color(255, 102, 0), new Color(255, 153, 0), new Color(255, 204, 0), new Color(255, 255, 0), new Color(204, 255, 0), new Color(153, 255, 0), new Color(102, 255, 0), new Color(51, 255, 0), new Color(0, 255, 0), new Color(0, 255, 51), new Color(0, 255, 102), new Color(0, 255, 153), new Color(0, 255, 204), new Color(102, 102, 102), C000204204, C000204204, new Color(0, 153, 204), new Color(0, 102, 204), new Color(0, 51, 204), new Color(0, 0, 204), new Color(51, 0, 204), new Color(102, 0, 204), new Color(153, 0, 204), C204000204, C204000204, C204000204, new Color(204, 0, 153), new Color(204, 0, 102), new Color(204, 0, 51), new Color(204, 0, 0), new Color(204, 51, 0), new Color(204, 102, 0), new Color(204, 153, 0), C204204000, C204204000, C204204000, new Color(153, 204, 0), new Color(102, 204, 0), new Color(51, 204, 0), new Color(0, 204, 0), new Color(0, 204, 51), new Color(0, 204, 102), new Color(0, 204, 153), new Color(0, 204, 204), new Color(102, 102, 102), C000153153, C000153153, C000153153, new Color(0, 102, 153), new Color(0, 51, 153), new Color(0, 0, 153), new Color(51, 0, 153), new Color(102, 0, 153), C153000153, C153000153, C153000153, C153000153, C153000153, new Color(153, 0, 102), new Color(153, 0, 51), new Color(153, 0, 0), new Color(153, 51, 0), new Color(153, 102, 0), C153153000, C153153000, C153153000, C153153000, C153153000, new Color(102, 153, 0), new Color(51, 153, 0), new Color(0, 153, 0), new Color(0, 153, 51), new Color(0, 153, 102), C000153153, C000153153, new Color(51, 51, 51), C000102102, C000102102, C000102102, C000102102, new Color(0, 51, 102), new Color(0, 0, 102), new Color(51, 0, 102), C102000102, C102000102, C102000102, C102000102, C102000102, C102000102, C102000102, new Color(102, 0, 51), new Color(102, 0, 0), new Color(102, 51, 0), C102102000, C102102000, C102102000, C102102000, C102102000, C102102000, C102102000, new Color(51, 102, 0), new Color(0, 102, 0), new Color(0, 102, 51), C000102102, C000102102, C000102102, Color.BLACK, C000051051, C000051051, C000051051, C000051051, C000051051, new Color(0, 0, 51), C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, C051000051, new Color(51, 0, 0), C051051000, C051051000, C051051000, C051051000, C051051000, C051051000, C051051000, C051051000, new Color(0, 51, 0), C000051051, C000051051, C000051051, C000051051, new Color(51, 51, 51)};

        public Color getColorForPosition(int x, int y) {
            if (x % (this.cellWidth + this.gap) > this.cellWidth || y % (this.cellHeight + this.gap) > this.cellHeight) {
                return null;
            }
            int row = y / (this.cellHeight + this.gap);
            int col = x / (this.cellWidth + this.gap);
            return colors[row * this.numCols + col];
        }

        protected void initializeColors() {
        }

        public void paint(Graphics graphics) {
            int index = 0;
            Insets insets = this.getInsets();
            int currX = insets.left;
            int currY = insets.top;
            Color saved = graphics.getColor();
            int i = 0;
            while (i < this.numRows) {
                int j = 0;
                while (j < this.numCols) {
                    graphics.setColor(colors[index++]);
                    graphics.fill3DRect(currX, currY, this.cellWidth, this.cellHeight, true);
                    currX += this.gap + this.cellWidth;
                    ++j;
                }
                currX = insets.left;
                currY += this.gap + this.cellHeight;
                ++i;
            }
            graphics.setColor(saved);
        }

        public String getToolTipText(MouseEvent e) {
            Color c = this.getColorForPosition(e.getX(), e.getY());
            if (c == null) {
                return null;
            }
            return "" + c.getRed() + ',' + c.getGreen() + ',' + c.getBlue();
        }

        MainSwatchPanel() {
            this.numCols = 31;
            this.numRows = 9;
            this.initializeColors();
            this.revalidate();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class RecentSwatchPanel
    extends SwatchPanel {
        public static final Color defaultColor = Color.GRAY;
        Color[] colors;
        int start;

        public Color getColorForPosition(int x, int y) {
            if (x % (this.cellWidth + this.gap) > this.cellWidth || y % (this.cellHeight + this.gap) > this.cellHeight) {
                return null;
            }
            int row = y / (this.cellHeight + this.gap);
            int col = x / (this.cellWidth + this.gap);
            return this.colors[this.getIndexForCell(row, col)];
        }

        protected void initializeColors() {
            this.colors = new Color[this.numRows * this.numCols];
            int i = 0;
            while (i < this.colors.length) {
                this.colors[i] = defaultColor;
                ++i;
            }
        }

        private final int getIndexForCell(int row, int col) {
            return (row * this.numCols + col + this.start) % (this.numRows * this.numCols);
        }

        void addColorToQueue(Color c) {
            if (--this.start == -1) {
                this.start = this.numRows * this.numCols - 1;
            }
            this.colors[this.start] = c;
        }

        public void paint(Graphics g) {
            Color saved = g.getColor();
            Insets insets = this.getInsets();
            int currX = insets.left;
            int currY = insets.top;
            int i = 0;
            while (i < this.numRows) {
                int j = 0;
                while (j < this.numCols) {
                    g.setColor(this.colors[this.getIndexForCell(i, j)]);
                    g.fill3DRect(currX, currY, this.cellWidth, this.cellHeight, true);
                    currX += this.cellWidth + this.gap;
                    ++j;
                }
                currX = insets.left;
                currY += this.cellWidth + this.gap;
                ++i;
            }
        }

        public String getToolTipText(MouseEvent e) {
            Color c = this.getColorForPosition(e.getX(), e.getY());
            if (c == null) {
                return null;
            }
            return "" + c.getRed() + ',' + c.getGreen() + ',' + c.getBlue();
        }

        private final /* synthetic */ void this() {
            this.start = 0;
        }

        RecentSwatchPanel() {
            this.this();
            this.numCols = 5;
            this.numRows = 7;
            this.initializeColors();
            this.revalidate();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            SwatchPanel panel = (SwatchPanel)e.getSource();
            Color c = panel.getColorForPosition(e.getX(), e.getY());
            DefaultSwatchChooserPanel.this.recentPalette.addColorToQueue(c);
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(c);
            DefaultSwatchChooserPanel.this.repaint();
        }

        MouseHandler() {
        }
    }

    static class RecentPanelLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            Component[] comps = parent.getComponents();
            Dimension parentSize = parent.getSize();
            Insets insets = parent.getInsets();
            int currY = insets.top;
            int i = 0;
            while (i < comps.length) {
                Dimension pref = comps[i].getPreferredSize();
                if (pref != null) {
                    comps[i].setBounds(insets.left, currY, pref.width, pref.height);
                    currY += pref.height;
                }
                ++i;
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            int width = 0;
            int height = 0;
            Insets insets = parent.getInsets();
            Component[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                Dimension pref = comps[i].getPreferredSize();
                if (pref != null) {
                    width = Math.max(width, pref.width);
                    height += pref.height;
                }
                ++i;
            }
            return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component comp) {
        }

        RecentPanelLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class SwatchPanel
    extends JPanel {
        protected int cellWidth;
        protected int cellHeight;
        protected int gap;
        protected int numRows;
        protected int numCols;

        public Dimension getPreferredSize() {
            int height = this.numRows * this.cellHeight + (this.numRows - 1) * this.gap;
            int width = this.numCols * this.cellWidth + (this.numCols - 1) * this.gap;
            Insets insets = this.getInsets();
            return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
        }

        public abstract Color getColorForPosition(int var1, int var2);

        protected abstract void initializeColors();

        private final /* synthetic */ void this() {
            this.cellWidth = 10;
            this.cellHeight = 10;
            this.gap = 1;
        }

        SwatchPanel() {
            this.this();
            this.setBackground(Color.WHITE);
        }
    }
}

