/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BasicMenuUI
extends BasicMenuItemUI {
    protected ChangeListener changeListener;
    protected MenuListener menuListener;
    protected PropertyChangeListener propertyChangeListener;

    protected ChangeListener createChangeListener(JComponent c) {
        return new ChangeHandler((JMenu)c, this);
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    protected MenuListener createMenuListener(JComponent c) {
        return new MenuHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuUI();
    }

    public Dimension getMaximumSize(JComponent c) {
        return c.getPreferredSize();
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.menuItem, "Menu.border");
        LookAndFeel.installColorsAndFont(this.menuItem, "Menu.background", "Menu.foreground", "Menu.font");
        this.menuItem.setMargin(UIManager.getInsets("Menu.margin"));
        this.acceleratorFont = UIManager.getFont("Menu.acceleratorFont");
        this.acceleratorForeground = UIManager.getColor("Menu.acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor("Menu.acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor("Menu.selectionBackground");
        this.selectionForeground = UIManager.getColor("Menu.selectionForeground");
        this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        this.oldBorderPainted = UIManager.getBoolean("Menu.borderPainted");
        this.menuItem.setOpaque(true);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        ((JMenu)this.menuItem).addMouseListener(this.mouseInputListener);
        ((JMenu)this.menuItem).addMouseMotionListener(this.mouseInputListener);
        ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        ((JMenu)this.menuItem).addMenuDragMouseListener(this.menuDragMouseListener);
    }

    protected void setupPostTimer(JMenu menu) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.arrowIcon = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        ((JMenu)this.menuItem).removeMouseListener(this.mouseInputListener);
        ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        ((JMenu)this.menuItem).removePropertyChangeListener(this.propertyChangeListener);
    }

    public BasicMenuUI() {
        this.mouseInputListener = this.createMouseInputListener((JMenu)this.menuItem);
        this.menuListener = this.createMenuListener((JMenu)this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener((JMenu)this.menuItem);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ChangeHandler
    implements ChangeListener {
        public boolean isSelected;
        public JMenu menu;
        public BasicMenuUI ui;
        public Component wasFocused;

        public void stateChanged(ChangeEvent e) {
        }

        public ChangeHandler(JMenu m, BasicMenuUI ui) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MenuDragMouseHandler
    implements MenuDragMouseListener {
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }

        protected MenuDragMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MenuKeyHandler
    implements MenuKeyListener {
        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
        }

        protected MenuKeyHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MenuHandler
    implements MenuListener {
        public void menuCanceled(MenuEvent e) {
            this.menuDeselected(e);
        }

        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (menu.getParent() != null) {
                if (menu.isTopLevelMenu()) {
                    ((JMenuBar)menu.getParent()).getSelectionModel().clearSelection();
                } else {
                    ((JPopupMenu)menu.getParent()).getSelectionModel().clearSelection();
                }
            }
        }

        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (menu.isTopLevelMenu()) {
                ((JMenuBar)menu.getParent()).setSelected(menu);
            } else {
                ((JPopupMenu)menu.getParent()).setSelected(menu);
            }
        }

        protected MenuHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        private final boolean popupVisible() {
            JMenuBar mb = (JMenuBar)((JMenu)BasicMenuUI.this.menuItem).getParent();
            if (!mb.isSelected()) {
                return false;
            }
            int i = 0;
            while (i < mb.getMenuCount()) {
                JMenu m = mb.getMenu(i);
                if (m != null && m.isPopupMenuVisible()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            if (!menu.isTopLevelMenu() || this.popupVisible()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.setSelectedPath(BasicMenuUI.this.getPath());
                manager.processMouseEvent(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            JMenu menu = (JMenu)BasicMenuUI.this.menuItem;
            manager.processMouseEvent(e);
            if (menu.isTopLevelMenu()) {
                if (menu.getPopupMenu().isVisible()) {
                    manager.clearSelectedPath();
                } else {
                    boolean x = false;
                    int y = menu.getHeight();
                    manager.setSelectedPath(BasicMenuUI.this.getPath());
                    JMenuBar mb = (JMenuBar)menu.getParent();
                    mb.getSelectionModel().setSelectedIndex(mb.getComponentIndex(menu));
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        protected MouseInputHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
        }

        protected PropertyChangeHandler() {
        }
    }
}

