/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.View;

public class BoxView
extends CompositeView {
    int myAxis;
    boolean xLayoutValid;
    boolean yLayoutValid;
    int[] spansX;
    int[] spansY;
    int[] offsetsX;
    int[] offsetsY;
    int width;
    int height;

    public int getAxis() {
        return this.myAxis;
    }

    public void setAxis(int axis) {
        this.myAxis = axis;
    }

    public void layoutChanged(int axis) {
        switch (axis) {
            case 0: {
                this.xLayoutValid = false;
                break;
            }
            case 1: {
                this.yLayoutValid = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid axis parameter.");
            }
        }
    }

    protected boolean isLayoutValid(int axis) {
        boolean valid = false;
        switch (axis) {
            case 0: {
                valid = this.xLayoutValid;
                break;
            }
            case 1: {
                valid = this.yLayoutValid;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid axis parameter.");
            }
        }
        return valid;
    }

    protected void paintChild(Graphics g, Rectangle alloc, int index) {
        View child = this.getView(index);
        child.paint(g, alloc);
    }

    public void replace(int offset, int length, View[] views) {
        int oldSize = this.getViewCount();
        int[] newSpansX = new int[oldSize - length + views.length];
        System.arraycopy(this.spansX, 0, newSpansX, 0, offset);
        System.arraycopy(this.spansX, offset + length, newSpansX, offset + views.length, oldSize - (offset + length));
        this.spansX = newSpansX;
        int[] newSpansY = new int[oldSize - length + views.length];
        System.arraycopy(this.spansY, 0, newSpansY, 0, offset);
        System.arraycopy(this.spansY, offset + length, newSpansY, offset + views.length, oldSize - (offset + length));
        this.spansY = newSpansY;
        int[] newOffsetsX = new int[oldSize - length + views.length];
        System.arraycopy(this.offsetsX, 0, newOffsetsX, 0, offset);
        System.arraycopy(this.offsetsX, offset + length, newOffsetsX, offset + views.length, oldSize - (offset + length));
        this.offsetsX = newOffsetsX;
        int[] newOffsetsY = new int[oldSize - length + views.length];
        System.arraycopy(this.offsetsY, 0, newOffsetsY, 0, offset);
        System.arraycopy(this.offsetsY, offset + length, newOffsetsY, offset + views.length, oldSize - (offset + length));
        this.offsetsY = newOffsetsY;
        super.replace(offset, length, views);
        this.layoutChanged(0);
        this.layoutChanged(1);
    }

    public void paint(Graphics g, Shape a) {
        Rectangle bounds = a.getBounds();
        if (bounds.width != this.getWidth() || bounds.height != this.getHeight()) {
            this.setSize(bounds.width, bounds.height);
        }
        Rectangle inside = this.getInsideAllocation(a);
        Rectangle copy = new Rectangle(inside);
        int count = this.getViewCount();
        int i = 0;
        while (i < count) {
            copy.setBounds(inside);
            this.childAllocation(i, copy);
            if (!copy.isEmpty()) {
                this.paintChild(g, copy, i);
            }
            ++i;
        }
    }

    public float getPreferredSpan(int axis) {
        SizeRequirements sr = new SizeRequirements();
        int pref = this.baselineRequirements((int)axis, (SizeRequirements)sr).preferred;
        return pref;
    }

    public float getMaximumSpan(int axis) {
        if (axis == this.getAxis()) {
            return this.getPreferredSpan(axis);
        }
        return 2.1474836E9f;
    }

    protected SizeRequirements baselineRequirements(int axis, SizeRequirements sr) {
        SizeRequirements result = axis == this.myAxis ? this.calculateMajorAxisRequirements(axis, sr) : this.calculateMinorAxisRequirements(axis, sr);
        return result;
    }

    protected void baselineLayout(int span, int axis, int[] offsets, int[] spans) {
        if (axis == this.myAxis) {
            this.layoutMajorAxis(span, axis, offsets, spans);
        } else {
            this.layoutMinorAxis(span, axis, offsets, spans);
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements sr) {
        SizeRequirements[] childReqs = this.getChildRequirements(axis);
        return SizeRequirements.getTiledSizeRequirements(childReqs);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements sr) {
        SizeRequirements[] childReqs = this.getChildRequirements(axis);
        return SizeRequirements.getAlignedSizeRequirements(childReqs);
    }

    protected boolean isBefore(int x, int y, Rectangle r) {
        boolean result = false;
        if (this.myAxis == 0) {
            boolean bl = false;
            if (x < r.x) {
                bl = true;
            }
            result = bl;
        } else {
            boolean bl = false;
            if (y < r.y) {
                bl = true;
            }
            result = bl;
        }
        return result;
    }

    protected boolean isAfter(int x, int y, Rectangle r) {
        boolean result = false;
        if (this.myAxis == 0) {
            boolean bl = false;
            if (x > r.x) {
                bl = true;
            }
            result = bl;
        } else {
            boolean bl = false;
            if (y > r.y) {
                bl = true;
            }
            result = bl;
        }
        return result;
    }

    protected View getViewAtPoint(int x, int y, Rectangle r) {
        View result = null;
        int count = this.getViewCount();
        Rectangle copy = new Rectangle(r);
        int i = 0;
        while (i < count) {
            copy.setBounds(r);
            this.childAllocation(i, r);
            if (copy.contains(x, y)) {
                result = this.getView(i);
                break;
            }
            ++i;
        }
        return result;
    }

    protected void childAllocation(int index, Rectangle a) {
        if (!this.isAllocationValid()) {
            this.layout(a.width, a.height);
        }
        a.x += this.offsetsX[index];
        a.y += this.offsetsY[index];
        a.width = this.spansX[index];
        a.height = this.spansY[index];
    }

    protected void layout(int width, int height) {
        this.baselineLayout(width, 0, this.offsetsX, this.spansX);
        this.baselineLayout(height, 1, this.offsetsY, this.spansY);
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        SizeRequirements[] childReqs = this.getChildRequirements(axis);
        SizeRequirements.calculateTiledPositions(targetSpan, null, childReqs, offsets, spans);
        this.validateLayout(axis);
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        SizeRequirements[] childReqs = this.getChildRequirements(axis);
        SizeRequirements total = this.baselineRequirements(axis, null);
        SizeRequirements.calculateAlignedPositions(targetSpan, total, childReqs, offsets, spans);
        this.validateLayout(axis);
    }

    protected boolean isAllocationValid() {
        boolean bl = false;
        if (this.isLayoutValid(0) && this.isLayoutValid(1)) {
            bl = true;
        }
        return bl;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(float width, float height) {
        if (this.width != (int)width) {
            this.layoutChanged(0);
        }
        if (this.height != (int)height) {
            this.layoutChanged(1);
        }
        this.width = (int)width;
        this.height = (int)height;
        Rectangle outside = new Rectangle(0, 0, this.width, this.height);
        Rectangle inside = this.getInsideAllocation(outside);
        if (!this.isAllocationValid()) {
            this.layout(inside.width, inside.height);
        }
    }

    void validateLayout(int axis) {
        if (axis == 0) {
            this.xLayoutValid = true;
        }
        if (axis == 1) {
            this.yLayoutValid = true;
        }
    }

    SizeRequirements[] getChildRequirements(int axis) {
        int count = this.getViewCount();
        SizeRequirements[] childReqs = new SizeRequirements[count];
        int i = 0;
        while (i < count) {
            View view = this.getView(i);
            childReqs[i] = new SizeRequirements((int)view.getMinimumSpan(axis), (int)view.getPreferredSpan(axis), (int)view.getMaximumSpan(axis), view.getAlignment(axis));
            ++i;
        }
        return childReqs;
    }

    protected int getSpan(int axis, int childIndex) {
        if (axis == 0) {
            return this.spansX[childIndex];
        }
        return this.spansY[childIndex];
    }

    protected int getOffset(int axis, int childIndex) {
        if (axis == 0) {
            return this.offsetsX[childIndex];
        }
        return this.offsetsY[childIndex];
    }

    public float getAlignment(int axis) {
        if (axis == this.myAxis) {
            return 0.5f;
        }
        return this.baselineRequirements((int)axis, null).alignment;
    }

    public void preferenceChanged(View child, boolean width, boolean height) {
        if (width) {
            this.xLayoutValid = false;
        }
        if (height) {
            this.yLayoutValid = false;
        }
        super.preferenceChanged(child, width, height);
    }

    public BoxView(Element element, int axis) {
        super(element);
        this.myAxis = axis;
        this.xLayoutValid = false;
        this.yLayoutValid = false;
        this.spansX = new int[0];
        this.spansY = new int[0];
        this.offsetsX = new int[0];
        this.offsetsY = new int[0];
        this.width = 0;
        this.height = 0;
    }
}

