/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.EmptySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TailIterator<T extends Item>
implements SequenceIterator<T>,
LastPositionFinder<T>,
LookaheadIterator<T> {
    private SequenceIterator<T> base;
    private int start;

    private TailIterator(SequenceIterator<T> base, int start) {
        this.base = base;
        this.start = start;
    }

    public static <T extends Item> SequenceIterator<T> make(SequenceIterator<T> base, int start) throws XPathException {
        if (start <= 1) {
            return base;
        }
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(start, Integer.MAX_VALUE);
        }
        if ((base.getProperties() & 1) != 0) {
            GroundedValue value = ((GroundedIterator)base).materialize();
            if (value == EmptySequence.getInstance()) {
                return EmptyIterator.emptyIterator();
            }
            return new ValueTailIterator(value, start - 1);
        }
        for (int i = 0; i < start - 1; ++i) {
            T b = base.next();
            if (b != null) continue;
            return EmptyIterator.emptyIterator();
        }
        return new TailIterator<T>(base, start);
    }

    @Override
    public T next() throws XPathException {
        return this.base.next();
    }

    @Override
    public T current() {
        return this.base.current();
    }

    @Override
    public int position() {
        int bp = this.base.position();
        return bp > 0 ? this.base.position() - this.start + 1 : bp;
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public int getLength() throws XPathException {
        int bl = ((LastPositionFinder)((Object)this.base)).getLength() - this.start + 1;
        return bl > 0 ? bl : 0;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator<T> getAnother() throws XPathException {
        return TailIterator.make(this.base.getAnother(), this.start);
    }

    @Override
    public int getProperties() {
        return this.base.getProperties() & 6;
    }
}

