/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AnalyzeMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeString
extends Instruction {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private Expression matching;
    private Expression nonMatching;
    private RegularExpression pattern;
    private boolean allow30features = false;
    private boolean useXsltErrorCodes = true;

    public AnalyzeString(Expression select, Expression regex, Expression flags, Expression matching, Expression nonMatching, RegularExpression pattern) {
        this.select = select;
        this.regex = regex;
        this.flags = flags;
        this.matching = matching;
        this.nonMatching = nonMatching;
        this.pattern = pattern;
        Iterator<Expression> kids = this.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression child = kids.next();
            this.adoptChildExpression(child);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 130;
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public RegularExpression getPatternExpression() {
        return this.pattern;
    }

    public Expression getFlagsExpression() {
        return this.flags;
    }

    public boolean isAllow30features() {
        return this.allow30features;
    }

    public void setUseXsltErrorCodes(boolean xslt) {
        this.useXsltErrorCodes = xslt;
    }

    public boolean isUseXsltErrorCodes() {
        return this.useXsltErrorCodes;
    }

    public Expression getRegexExpression() {
        return this.regex;
    }

    public Expression getMatchingExpression() {
        return this.matching;
    }

    public Expression getNonMatchingExpression() {
        return this.nonMatching;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.regex = visitor.simplify(this.regex);
        this.flags = visitor.simplify(this.flags);
        this.matching = visitor.simplify(this.matching);
        this.nonMatching = visitor.simplify(this.nonMatching);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.allow30features = visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE);
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.regex = visitor.typeCheck(this.regex, contextItemType);
        this.adoptChildExpression(this.regex);
        this.flags = visitor.typeCheck(this.flags, contextItemType);
        this.adoptChildExpression(this.flags);
        if (this.matching != null) {
            this.matching = visitor.typeCheck(this.matching, new ExpressionVisitor.ContextItemType(BuiltInAtomicType.STRING, false));
            this.adoptChildExpression(this.matching);
        }
        if (this.nonMatching != null) {
            this.nonMatching = visitor.typeCheck(this.nonMatching, new ExpressionVisitor.ContextItemType(BuiltInAtomicType.STRING, false));
            this.adoptChildExpression(this.nonMatching);
        }
        RoleLocator role = new RoleLocator(4, "analyze-string/select", 0);
        SequenceType required = this.allow30features ? SequenceType.OPTIONAL_STRING : SequenceType.SINGLE_STRING;
        this.select = TypeChecker.staticTypeCheck(this.select, required, false, role, visitor);
        role = new RoleLocator(4, "analyze-string/regex", 0);
        this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, role, visitor);
        role = new RoleLocator(4, "analyze-string/flags", 0);
        this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, role, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.regex = visitor.optimize(this.regex, contextItemType);
        this.adoptChildExpression(this.regex);
        this.flags = visitor.optimize(this.flags, contextItemType);
        this.adoptChildExpression(this.flags);
        if (this.matching != null) {
            this.matching = this.matching.optimize(visitor, new ExpressionVisitor.ContextItemType(BuiltInAtomicType.STRING, false));
            this.adoptChildExpression(this.matching);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.optimize(visitor, new ExpressionVisitor.ContextItemType(BuiltInAtomicType.STRING, false));
            this.adoptChildExpression(this.nonMatching);
        }
        if (this.pattern == null && this.regex instanceof StringLiteral && this.flags instanceof StringLiteral) {
            try {
                String regex = ((StringLiteral)this.regex).getStringValue();
                String flagstr = ((StringLiteral)this.flags).getStringValue();
                String hostLang = DecimalValue.THREE.equals(visitor.getStaticContext().getXPathLanguageLevel()) ? "XP30" : "XP20";
                ArrayList<String> warnings = new ArrayList<String>();
                this.pattern = Configuration.getPlatform().compileRegularExpression(regex, flagstr.toString(), hostLang, warnings);
                for (String w : warnings) {
                    visitor.getStaticContext().issueWarning(w, this);
                }
                if (this.pattern.matches("")) {
                    this.pattern = Configuration.getPlatform().compileRegularExpression("x", "", "XP20", warnings);
                    this.invalidRegex("The regular expression must not be one that matches a zero-length string", this.useXsltErrorCodes ? "XTDE1150" : "FORX0003");
                }
            }
            catch (XPathException err) {
                if ("XTDE1150".equals(err.getErrorCodeLocalPart())) {
                    throw err;
                }
                if ("FORX0001".equals(err.getErrorCodeLocalPart())) {
                    this.invalidRegex("Error in regular expression flags: " + err, this.useXsltErrorCodes ? "XTDE1145" : "FORX0001");
                }
                this.invalidRegex("Error in regular expression: " + err, this.useXsltErrorCodes ? "XTDE1140" : err.getErrorCodeLocalPart());
            }
        }
        return this;
    }

    private void invalidRegex(String message, String errorCode) throws XPathException {
        this.pattern = null;
        XPathException err = new XPathException(message, errorCode);
        err.setLocator(this);
        throw err;
    }

    @Override
    public Expression copy() {
        return new AnalyzeString(this.copy(this.select), this.copy(this.regex), this.copy(this.flags), this.copy(this.matching), this.copy(this.nonMatching), this.pattern);
    }

    private Expression copy(Expression exp) {
        return exp == null ? null : exp.copy();
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.matching != null) {
            this.matching.checkPermittedContents(parentType, env, false);
        }
        if (this.nonMatching != null) {
            this.nonMatching.checkPermittedContents(parentType, env, false);
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.matching != null) {
            if (this.nonMatching != null) {
                return Type.getCommonSuperType(this.matching.getItemType(th), this.nonMatching.getItemType(th), th);
            }
            return this.matching.getItemType(th);
        }
        if (this.nonMatching != null) {
            return this.nonMatching.getItemType(th);
        }
        return EmptySequenceTest.getInstance();
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.regex.getDependencies();
        dependencies |= this.flags.getDependencies();
        if (this.matching != null) {
            dependencies |= this.matching.getDependencies() & 0xFFFFFFA1;
        }
        if (this.nonMatching != null) {
            dependencies |= this.nonMatching.getDependencies() & 0xFFFFFFA1;
        }
        return dependencies;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.regex = this.doPromotion(this.regex, offer);
        this.flags = this.doPromotion(this.flags, offer);
        if (this.matching != null) {
            this.matching = this.doPromotion(this.matching, offer);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.doPromotion(this.nonMatching, offer);
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(5);
        list.add(this.select);
        list.add(this.regex);
        list.add(this.flags);
        if (this.matching != null) {
            list.add(this.matching);
        }
        if (this.nonMatching != null) {
            list.add(this.nonMatching);
        }
        return list.iterator();
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        ArrayList<SubExpressionInfo> list = new ArrayList<SubExpressionInfo>(5);
        list.add(new SubExpressionInfo(this.select, true, false, 1));
        list.add(new SubExpressionInfo(this.regex, true, false, 1));
        list.add(new SubExpressionInfo(this.flags, true, false, 1));
        if (this.matching != null) {
            list.add(new SubExpressionInfo(this.matching, false, true, 0));
        }
        if (this.nonMatching != null) {
            list.add(new SubExpressionInfo(this.nonMatching, false, true, 0));
        }
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.regex == original) {
            this.regex = replacement;
            found = true;
        }
        if (this.flags == original) {
            this.flags = replacement;
            found = true;
        }
        if (this.matching == original) {
            this.matching = replacement;
            found = true;
        }
        if (this.nonMatching == original) {
            this.nonMatching = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Object it;
        RegexIterator iter = this.getRegexIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentRegexIterator(iter);
        while ((it = iter.next()) != null) {
            if (iter.isMatching()) {
                if (this.matching == null) continue;
                this.matching.process(c2);
                continue;
            }
            if (this.nonMatching == null) continue;
            this.nonMatching.process(c2);
        }
        return null;
    }

    private RegexIterator getRegexIterator(XPathContext context) throws XPathException {
        CharSequence input = this.select.evaluateAsString(context);
        RegularExpression re = this.pattern;
        if (re == null) {
            CharSequence flagstr = this.flags.evaluateAsString(context);
            re = Configuration.getPlatform().compileRegularExpression(this.regex.evaluateAsString(context), flagstr.toString(), this.allow30features ? "XP30" : "XP20", null);
            if (re.matches("")) {
                this.dynamicError("The regular expression must not be one that matches a zero-length string", "XTDE1150", context);
            }
        }
        return re.analyze(input);
    }

    public SequenceIterator<StringValue> iterate(XPathContext context) throws XPathException {
        RegexIterator iter = this.getRegexIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentRegexIterator(iter);
        AnalyzeMappingFunction fn = new AnalyzeMappingFunction(iter, c2, this.nonMatching, this.matching);
        return new ContextMappingIterator<StringValue>(fn, c2);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("analyzeString");
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("regex");
        this.regex.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("flags");
        this.flags.explain(out);
        out.endSubsidiaryElement();
        if (this.matching != null) {
            out.startSubsidiaryElement("matching");
            this.matching.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.nonMatching != null) {
            out.startSubsidiaryElement("nonMatching");
            this.nonMatching.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

