/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;

public class CurrentDateTime
extends SystemFunctionCall
implements Callable {
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int getIntrinsicDependencies() {
        return 1024;
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        DateTimeValue dt = DateTimeValue.getCurrentDateTime(context);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        int targetType = this.getItemType(th).getPrimitiveType();
        switch (targetType) {
            case 519: {
                return dt;
            }
            case 521: {
                return Converter.DATE_TIME_TO_DATE.convert(dt).asAtomic();
            }
            case 520: {
                return Converter.DATE_TIME_TO_TIME.convert(dt).asAtomic();
            }
            case 518: 
            case 634: {
                return dt.getComponent(7);
            }
        }
        throw new IllegalArgumentException("Wrong target type for current date/time");
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evaluateItem(context);
    }
}

