/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class Put
extends SystemFunctionCall {
    String expressionBaseURI = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
            if (this.expressionBaseURI == null && this.argument.length == 1) {
                XPathException de = new XPathException("Base URI in static context of put() is unknown");
                de.setErrorCode("FONS0005");
                throw de;
            }
        }
    }

    public Expression copy() {
        Put d = (Put)super.copy();
        d.expressionBaseURI = this.expressionBaseURI;
        return d;
    }

    public boolean equals(Object o) {
        return o instanceof Put && super.equals(o) && Put.equalOrNull(this.expressionBaseURI, ((Put)o).expressionBaseURI);
    }

    public boolean isUpdatingExpression() {
        return true;
    }

    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        String abs;
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(context);
        int kind = node.getNodeKind();
        if (kind != 1 && kind != 9) {
            this.dynamicError("Node in put() must be a document or element node", "FOUP0001", context);
        }
        String relative = this.argument[1].evaluateItem(context).getStringValue();
        try {
            URI resolved = ResolveURI.makeAbsolute(relative, this.expressionBaseURI);
            abs = resolved.toString();
        }
        catch (URISyntaxException err) {
            this.dynamicError("Base URI " + Err.wrap(this.expressionBaseURI) + " is invalid: " + err.getMessage(), "FOUP0002", context);
            abs = null;
        }
        pul.addPutAction(node, abs, this);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        throw new XPathException("Dynamic evaluation of fn:put() is not supported");
    }
}

