/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

public class StaticContextForSystemFunctions {
    private String baseURI = null;
    private Executable executable;
    private String defaultElementNamespace = "";
    private DecimalFormatManager decimalFormatManager = null;

    public StaticContextForSystemFunctions(Executable exec) {
        this.executable = exec;
    }

    public Configuration getConfiguration() {
        return this.executable.getConfiguration();
    }

    public CollationMap getCollationMap() {
        return this.executable.getCollationTable();
    }

    public boolean isSchemaAware() {
        return this.executable.isSchemaAware();
    }

    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.getCollationMap());
    }

    public LocationMap getLocationMap() {
        return null;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public FunctionLibrary getFunctionLibrary() {
        return null;
    }

    public StringCollator getCollation(String name) {
        return this.getCollationMap().getNamedCollation(name);
    }

    public String getDefaultCollationName() {
        return this.getCollationMap().getDefaultCollationName();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public void issueWarning(String s, SourceLocator locator) {
        try {
            this.getConfiguration().getErrorListener().warning(new XPathException(s));
        }
        catch (TransformerException e) {
            this.getConfiguration().getStandardErrorOutput().println("Warning: " + s);
        }
    }

    public String getSystemId() {
        return "";
    }

    public int getLineNumber() {
        return -1;
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    public String getDefaultFunctionNamespace() {
        return null;
    }

    public DecimalValue getXPathLanguageLevel() {
        return DecimalValue.TWO;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return true;
    }

    public void setDecimalFormatManager(DecimalFormatManager manager) {
        this.decimalFormatManager = manager;
    }

    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }
}

