/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.DedicatedStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;

public class XPathCompiler {
    private Processor processor;
    private IndependentContext env;
    private ItemType requiredContextItemType;
    private Map<String, XPathExecutable> cache = null;

    protected XPathCompiler(Processor processor) {
        this.processor = processor;
        this.env = new IndependentContext(processor.getUnderlyingConfiguration());
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setBackwardsCompatible(boolean option) {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.env.setBackwardsCompatibilityMode(option);
    }

    public boolean isBackwardsCompatible() {
        return this.env.isInBackwardsCompatibleMode();
    }

    public void setSchemaAware(boolean schemaAware) {
        this.env.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.env.isSchemaAware();
    }

    public void setLanguageVersion(String version) {
        DecimalValue dv;
        if (this.cache != null) {
            this.cache.clear();
        }
        try {
            dv = (DecimalValue)DecimalValue.makeDecimalValue(version, true).asAtomic();
        }
        catch (ValidationException err) {
            throw new IllegalArgumentException("Language version must be in the form of a decimal number");
        }
        if (DecimalValue.ONE.equals(dv)) {
            dv = DecimalValue.TWO;
            this.env.setBackwardsCompatibilityMode(true);
        }
        if (!(DecimalValue.ONE.equals(dv) || DecimalValue.TWO.equals(dv) || DecimalValue.THREE.equals(dv))) {
            throw new IllegalArgumentException("Unknown XPath language version " + version);
        }
        this.env.setXPathLanguageLevel(dv);
    }

    public String getLanguageVersion() {
        return this.env.getXPathLanguageLevel().equals(DecimalValue.TWO) ? "2.0" : "3.0";
    }

    public void setBaseURI(URI uri) {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (uri == null) {
            this.env.setBaseURI(null);
        } else {
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("Supplied base URI must be absolute");
            }
            this.env.setBaseURI(uri.toString());
        }
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void declareNamespace(String prefix, String uri) {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.env.declareNamespace(prefix, uri);
    }

    public void importSchemaNamespace(String uri) {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.env.getImportedSchemaNamespaces().add(uri);
        this.env.setSchemaAware(true);
    }

    public void setAllowUndeclaredVariables(boolean allow) {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.env.setAllowUndeclaredVariables(allow);
    }

    public boolean isAllowUndeclaredVariables() {
        return this.env.isAllowUndeclaredVariables();
    }

    public void declareVariable(QName qname) {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
    }

    public void declareVariable(QName qname, ItemType itemType, OccurrenceIndicator occurrences) throws SaxonApiException {
        if (this.cache != null) {
            this.cache.clear();
        }
        XPathVariable var = this.env.declareVariable(qname.getNamespaceURI(), qname.getLocalName());
        var.setRequiredType(SequenceType.makeSequenceType(itemType.getUnderlyingItemType(), occurrences.getCardinality()));
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
        this.env.setRequiredContextItemType(type.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void declareCollation(String uri, Collator collation) {
        if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new IllegalArgumentException("Cannot declare the Unicode codepoint collation URI");
        }
        SimpleCollation saxonCollation = collation instanceof RuleBasedCollator ? new RuleBasedSubstringMatcher((RuleBasedCollator)collation) : new SimpleCollation(collation);
        this.env.getCollationMap().setNamedCollation(uri, saxonCollation);
    }

    public void declareDefaultCollation(String uri) {
        if (this.env.getCollationMap().getNamedCollation(uri) == null) {
            throw new IllegalStateException("Unknown collation " + uri);
        }
        this.env.getCollationMap().setDefaultCollationName(uri);
    }

    public void setCaching(boolean caching) {
        if (caching) {
            if (this.cache == null) {
                this.cache = new ConcurrentHashMap<String, XPathExecutable>();
            }
        } else {
            this.cache = null;
        }
    }

    public boolean isCaching() {
        return this.cache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XPathExecutable compile(String source) throws SaxonApiException {
        if (this.cache != null) {
            XPathCompiler xPathCompiler = this;
            synchronized (xPathCompiler) {
                XPathExecutable expr = this.cache.get(source);
                if (expr == null) {
                    expr = this.internalCompile(source);
                    this.cache.put(source, expr);
                }
                return expr;
            }
        }
        return this.internalCompile(source);
    }

    private XPathExecutable internalCompile(String source) throws SaxonApiException {
        try {
            this.env.getDecimalFormatManager().checkConsistency();
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        IndependentContext ic = this.env;
        if (ic.isAllowUndeclaredVariables()) {
            ic = new DedicatedStaticContext(this.env);
            Iterator<XPathVariable> iter = this.env.iterateExternalVariables();
            while (iter.hasNext()) {
                XPathVariable var = iter.next();
                XPathVariable var2 = ic.declareVariable(var.getVariableQName());
                var2.setRequiredType(var.getRequiredType());
            }
        }
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext(ic);
            XPathExpression cexp = eval.createExpression(source);
            cexp.getInternalExpression().getExecutable().setCollationMap(this.env.getCollationMap());
            return new XPathExecutable(cexp, this.processor, ic);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue evaluate(String expression, XdmItem contextItem) throws SaxonApiException {
        XPathSelector selector = this.compile(expression).load();
        if (contextItem != null) {
            selector.setContextItem(contextItem);
        }
        return selector.evaluate();
    }

    public XdmItem evaluateSingle(String expression, XdmItem contextItem) throws SaxonApiException {
        XPathSelector selector = this.compile(expression).load();
        if (contextItem != null) {
            selector.setContextItem(contextItem);
        }
        return selector.evaluateSingle();
    }

    public XPathExecutable compilePattern(String source) throws SaxonApiException {
        try {
            this.env.getDecimalFormatManager().checkConsistency();
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        try {
            XPathEvaluator eval = new XPathEvaluator(this.processor.getUnderlyingConfiguration());
            eval.setStaticContext(this.env);
            XPathExpression cexp = eval.createPattern(source);
            return new XPathExecutable(cexp, this.processor, this.env);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void setDecimalFormatProperty(QName format, String property, String value) throws SaxonApiException {
        block13: {
            DecimalFormatManager dfm = this.env.getDecimalFormatManager();
            if (dfm == null) {
                dfm = new DecimalFormatManager();
                this.env.setDecimalFormatManager(dfm);
            }
            DecimalSymbols symbols = dfm.getNamedDecimalFormat(format.getStructuredQName());
            try {
                if (property.equals("decimal-separator")) {
                    symbols.setDecimalSeparator(value);
                    break block13;
                }
                if (property.equals("grouping-separator")) {
                    symbols.setGroupingSeparator(value);
                    break block13;
                }
                if (property.equals("infinity")) {
                    symbols.setInfinity(value);
                    break block13;
                }
                if (property.equals("NaN")) {
                    symbols.setNaN(value);
                    break block13;
                }
                if (property.equals("minus-sign")) {
                    symbols.setMinusSign(value);
                    break block13;
                }
                if (property.equals("percent")) {
                    symbols.setPercent(value);
                    break block13;
                }
                if (property.equals("per-mille")) {
                    symbols.setPerMille(value);
                    break block13;
                }
                if (property.equals("zero-digit")) {
                    symbols.setZeroDigit(value);
                    break block13;
                }
                if (property.equals("digit")) {
                    symbols.setDigit(value);
                    break block13;
                }
                if (property.equals("pattern-separator")) {
                    symbols.setPatternSeparator(value);
                    break block13;
                }
                throw new IllegalArgumentException("**** Unknown decimal format attribute " + property);
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
    }

    public StaticContext getUnderlyingStaticContext() {
        return this.env;
    }
}

