/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.tree.wrapper.WrappingFunction;

public class WrappingIterator
implements AxisIterator {
    AxisIterator base;
    VirtualNode parent;
    NodeInfo current;
    boolean atomizing = false;
    WrappingFunction wrappingFunction;

    public WrappingIterator(AxisIterator base, WrappingFunction function, VirtualNode parent) {
        this.base = base;
        this.wrappingFunction = function;
        this.parent = parent;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public NodeInfo next() {
        Object n = this.base.next();
        this.current = n instanceof NodeInfo && !this.atomizing ? this.wrappingFunction.makeWrapper((NodeInfo)n, this.parent) : (NodeInfo)n;
        return this.current;
    }

    public NodeInfo current() {
        return this.current;
    }

    public int position() {
        return this.base.position();
    }

    public void close() {
        this.base.close();
    }

    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current.iterateAxis(axis, test);
    }

    public Sequence atomize() throws XPathException {
        return this.current.atomize();
    }

    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    public AxisIterator getAnother() {
        return new WrappingIterator(this.base.getAnother(), this.wrappingFunction, this.parent);
    }

    public int getProperties() {
        return 0;
    }
}

